
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "context",
    "objectTypes",
    "proxy"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class EnvoyConfigObjectMatch implements Serializable
{

    @JsonProperty("context")
    private PatchContext context;
    @JsonProperty("objectTypes")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1alpha3.EnvoyConfigObjectMatch.ObjectTypes objectTypes;
    /**
     * 
     */
    @JsonProperty("proxy")
    @JsonPropertyDescription("")
    private ProxyMatch proxy;
    private final static long serialVersionUID = -547041312987935625L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EnvoyConfigObjectMatch() {
    }

    /**
     * 
     * @param proxy
     * @param context
     * @param objectTypes
     */
    public EnvoyConfigObjectMatch(PatchContext context, me.snowdrop.istio.api.networking.v1alpha3.EnvoyConfigObjectMatch.ObjectTypes objectTypes, ProxyMatch proxy) {
        super();
        this.context = context;
        this.objectTypes = objectTypes;
        this.proxy = proxy;
    }

    public PatchContext getContext() {
        return context;
    }

    public void setContext(PatchContext context) {
        this.context = context;
    }

    public me.snowdrop.istio.api.networking.v1alpha3.EnvoyConfigObjectMatch.ObjectTypes getObjectTypes() {
        return objectTypes;
    }

    public void setObjectTypes(me.snowdrop.istio.api.networking.v1alpha3.EnvoyConfigObjectMatch.ObjectTypes objectTypes) {
        this.objectTypes = objectTypes;
    }

    /**
     * 
     */
    public ProxyMatch getProxy() {
        return proxy;
    }

    /**
     * 
     */
    public void setProxy(ProxyMatch proxy) {
        this.proxy = proxy;
    }

    public interface ObjectTypes extends Serializable
    {


    }

}
