package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EnvoyConfigObjectMatchBuilder extends EnvoyConfigObjectMatchFluentImpl<EnvoyConfigObjectMatchBuilder> implements VisitableBuilder<EnvoyConfigObjectMatch,EnvoyConfigObjectMatchBuilder>{

    EnvoyConfigObjectMatchFluent<?> fluent;
    Boolean validationEnabled;

    public EnvoyConfigObjectMatchBuilder(){
            this(true);
    }
    public EnvoyConfigObjectMatchBuilder(Boolean validationEnabled){
            this(new EnvoyConfigObjectMatch(), validationEnabled);
    }
    public EnvoyConfigObjectMatchBuilder(EnvoyConfigObjectMatchFluent<?> fluent){
            this(fluent, true);
    }
    public EnvoyConfigObjectMatchBuilder(EnvoyConfigObjectMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EnvoyConfigObjectMatch(), validationEnabled);
    }
    public EnvoyConfigObjectMatchBuilder(EnvoyConfigObjectMatchFluent<?> fluent,EnvoyConfigObjectMatch instance){
            this(fluent, instance, true);
    }
    public EnvoyConfigObjectMatchBuilder(EnvoyConfigObjectMatchFluent<?> fluent,EnvoyConfigObjectMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContext(instance.getContext()); 
            fluent.withObjectTypes(instance.getObjectTypes()); 
            fluent.withProxy(instance.getProxy()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvoyConfigObjectMatchBuilder(EnvoyConfigObjectMatch instance){
            this(instance,true);
    }
    public EnvoyConfigObjectMatchBuilder(EnvoyConfigObjectMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContext(instance.getContext()); 
            this.withObjectTypes(instance.getObjectTypes()); 
            this.withProxy(instance.getProxy()); 
            this.validationEnabled = validationEnabled; 
    }

    public EnvoyConfigObjectMatch build(){
            EnvoyConfigObjectMatch buildable = new EnvoyConfigObjectMatch(fluent.getContext(),fluent.getObjectTypes(),fluent.getProxy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvoyConfigObjectMatchBuilder that = (EnvoyConfigObjectMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
