
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "applyTo",
    "match",
    "patch"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class EnvoyConfigObjectPatch implements Serializable
{

    @JsonProperty("applyTo")
    private ApplyTo applyTo;
    /**
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    private EnvoyConfigObjectMatch match;
    /**
     * 
     */
    @JsonProperty("patch")
    @JsonPropertyDescription("")
    private Patch patch;
    private final static long serialVersionUID = 3106061065570191598L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EnvoyConfigObjectPatch() {
    }

    /**
     * 
     * @param patch
     * @param applyTo
     * @param match
     */
    public EnvoyConfigObjectPatch(ApplyTo applyTo, EnvoyConfigObjectMatch match, Patch patch) {
        super();
        this.applyTo = applyTo;
        this.match = match;
        this.patch = patch;
    }

    public ApplyTo getApplyTo() {
        return applyTo;
    }

    public void setApplyTo(ApplyTo applyTo) {
        this.applyTo = applyTo;
    }

    /**
     * 
     */
    public EnvoyConfigObjectMatch getMatch() {
        return match;
    }

    /**
     * 
     */
    public void setMatch(EnvoyConfigObjectMatch match) {
        this.match = match;
    }

    /**
     * 
     */
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     */
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

}
