package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EnvoyConfigObjectPatchBuilder extends EnvoyConfigObjectPatchFluentImpl<EnvoyConfigObjectPatchBuilder> implements VisitableBuilder<EnvoyConfigObjectPatch,EnvoyConfigObjectPatchBuilder>{

    EnvoyConfigObjectPatchFluent<?> fluent;
    Boolean validationEnabled;

    public EnvoyConfigObjectPatchBuilder(){
            this(true);
    }
    public EnvoyConfigObjectPatchBuilder(Boolean validationEnabled){
            this(new EnvoyConfigObjectPatch(), validationEnabled);
    }
    public EnvoyConfigObjectPatchBuilder(EnvoyConfigObjectPatchFluent<?> fluent){
            this(fluent, true);
    }
    public EnvoyConfigObjectPatchBuilder(EnvoyConfigObjectPatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EnvoyConfigObjectPatch(), validationEnabled);
    }
    public EnvoyConfigObjectPatchBuilder(EnvoyConfigObjectPatchFluent<?> fluent,EnvoyConfigObjectPatch instance){
            this(fluent, instance, true);
    }
    public EnvoyConfigObjectPatchBuilder(EnvoyConfigObjectPatchFluent<?> fluent,EnvoyConfigObjectPatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApplyTo(instance.getApplyTo()); 
            fluent.withMatch(instance.getMatch()); 
            fluent.withPatch(instance.getPatch()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvoyConfigObjectPatchBuilder(EnvoyConfigObjectPatch instance){
            this(instance,true);
    }
    public EnvoyConfigObjectPatchBuilder(EnvoyConfigObjectPatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApplyTo(instance.getApplyTo()); 
            this.withMatch(instance.getMatch()); 
            this.withPatch(instance.getPatch()); 
            this.validationEnabled = validationEnabled; 
    }

    public EnvoyConfigObjectPatch build(){
            EnvoyConfigObjectPatch buildable = new EnvoyConfigObjectPatch(fluent.getApplyTo(),fluent.getMatch(),fluent.getPatch());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvoyConfigObjectPatchBuilder that = (EnvoyConfigObjectPatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
