package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EnvoyFilterListBuilder extends EnvoyFilterListFluentImpl<EnvoyFilterListBuilder> implements VisitableBuilder<EnvoyFilterList,EnvoyFilterListBuilder>{

    EnvoyFilterListFluent<?> fluent;
    Boolean validationEnabled;

    public EnvoyFilterListBuilder(){
            this(true);
    }
    public EnvoyFilterListBuilder(Boolean validationEnabled){
            this(new EnvoyFilterList(), validationEnabled);
    }
    public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent){
            this(fluent, true);
    }
    public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EnvoyFilterList(), validationEnabled);
    }
    public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent,EnvoyFilterList instance){
            this(fluent, instance, true);
    }
    public EnvoyFilterListBuilder(EnvoyFilterListFluent<?> fluent,EnvoyFilterList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvoyFilterListBuilder(EnvoyFilterList instance){
            this(instance,true);
    }
    public EnvoyFilterListBuilder(EnvoyFilterList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public EnvoyFilterList build(){
            EnvoyFilterList buildable = new EnvoyFilterList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvoyFilterListBuilder that = (EnvoyFilterListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
