
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "configPatches",
    "workloadSelector"
})
@IstioKind(name = "EnvoyFilter", plural = "envoyfilters")
@IstioApiVersion("networking.istio.io/v1alpha3")
@Version("v1alpha3")
@Group("networking.istio.io")
@Plural("envoyfilters")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class EnvoyFilterSpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("configPatches")
    @JsonPropertyDescription("")
    private List<EnvoyConfigObjectPatch> configPatches = new ArrayList<EnvoyConfigObjectPatch>();
    /**
     * 
     */
    @JsonProperty("workloadSelector")
    @JsonPropertyDescription("")
    private WorkloadSelector workloadSelector;
    private final static long serialVersionUID = -5155299850599366059L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EnvoyFilterSpec() {
    }

    /**
     * 
     * @param workloadSelector
     * @param configPatches
     */
    public EnvoyFilterSpec(List<EnvoyConfigObjectPatch> configPatches, WorkloadSelector workloadSelector) {
        super();
        this.configPatches = configPatches;
        this.workloadSelector = workloadSelector;
    }

    /**
     * 
     */
    public List<EnvoyConfigObjectPatch> getConfigPatches() {
        return configPatches;
    }

    /**
     * 
     */
    public void setConfigPatches(List<EnvoyConfigObjectPatch> configPatches) {
        this.configPatches = configPatches;
    }

    /**
     * 
     */
    public WorkloadSelector getWorkloadSelector() {
        return workloadSelector;
    }

    /**
     * 
     */
    public void setWorkloadSelector(WorkloadSelector workloadSelector) {
        this.workloadSelector = workloadSelector;
    }

}
