package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class EnvoyFilterSpecFluentImpl<A extends EnvoyFilterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EnvoyFilterSpecFluent<A>{

    private List<EnvoyConfigObjectPatchBuilder> configPatches;
    private WorkloadSelectorBuilder workloadSelector;

    public EnvoyFilterSpecFluentImpl(){
    }
    public EnvoyFilterSpecFluentImpl(EnvoyFilterSpec instance){
            this.withConfigPatches(instance.getConfigPatches()); 
            this.withWorkloadSelector(instance.getWorkloadSelector()); 
    }

    public A addToConfigPatches(int index,EnvoyConfigObjectPatch item){
            if (this.configPatches == null) {this.configPatches = new ArrayList<EnvoyConfigObjectPatchBuilder>();}
            EnvoyConfigObjectPatchBuilder builder = new EnvoyConfigObjectPatchBuilder(item);_visitables.get("configPatches").add(index >= 0 ? index : _visitables.get("configPatches").size(), builder);this.configPatches.add(index >= 0 ? index : configPatches.size(), builder); return (A)this;
    }

    public A setToConfigPatches(int index,EnvoyConfigObjectPatch item){
            if (this.configPatches == null) {this.configPatches = new ArrayList<EnvoyConfigObjectPatchBuilder>();}
            EnvoyConfigObjectPatchBuilder builder = new EnvoyConfigObjectPatchBuilder(item);
            if (index < 0 || index >= _visitables.get("configPatches").size()) { _visitables.get("configPatches").add(builder); } else { _visitables.get("configPatches").set(index, builder);}
            if (index < 0 || index >= configPatches.size()) { configPatches.add(builder); } else { configPatches.set(index, builder);}
             return (A)this;
    }

    public A addToConfigPatches(EnvoyConfigObjectPatch... items){
            if (this.configPatches == null) {this.configPatches = new ArrayList<EnvoyConfigObjectPatchBuilder>();}
            for (EnvoyConfigObjectPatch item : items) {EnvoyConfigObjectPatchBuilder builder = new EnvoyConfigObjectPatchBuilder(item);_visitables.get("configPatches").add(builder);this.configPatches.add(builder);} return (A)this;
    }

    public A addAllToConfigPatches(Collection<EnvoyConfigObjectPatch> items){
            if (this.configPatches == null) {this.configPatches = new ArrayList<EnvoyConfigObjectPatchBuilder>();}
            for (EnvoyConfigObjectPatch item : items) {EnvoyConfigObjectPatchBuilder builder = new EnvoyConfigObjectPatchBuilder(item);_visitables.get("configPatches").add(builder);this.configPatches.add(builder);} return (A)this;
    }

    public A removeFromConfigPatches(EnvoyConfigObjectPatch... items){
            for (EnvoyConfigObjectPatch item : items) {EnvoyConfigObjectPatchBuilder builder = new EnvoyConfigObjectPatchBuilder(item);_visitables.get("configPatches").remove(builder);if (this.configPatches != null) {this.configPatches.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfigPatches(Collection<EnvoyConfigObjectPatch> items){
            for (EnvoyConfigObjectPatch item : items) {EnvoyConfigObjectPatchBuilder builder = new EnvoyConfigObjectPatchBuilder(item);_visitables.get("configPatches").remove(builder);if (this.configPatches != null) {this.configPatches.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfigPatches(io.fabric8.kubernetes.api.builder.Predicate<EnvoyConfigObjectPatchBuilder> predicate){
            if (configPatches == null) return (A) this;
            final Iterator<EnvoyConfigObjectPatchBuilder> each = configPatches.iterator();
            final List visitables = _visitables.get("configPatches");
            while (each.hasNext()) {
              EnvoyConfigObjectPatchBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfigPatches instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvoyConfigObjectPatch> getConfigPatches(){
            return build(configPatches);
    }

    public List<EnvoyConfigObjectPatch> buildConfigPatches(){
            return build(configPatches);
    }

    public EnvoyConfigObjectPatch buildConfigPatch(int index){
            return this.configPatches.get(index).build();
    }

    public EnvoyConfigObjectPatch buildFirstConfigPatch(){
            return this.configPatches.get(0).build();
    }

    public EnvoyConfigObjectPatch buildLastConfigPatch(){
            return this.configPatches.get(configPatches.size() - 1).build();
    }

    public EnvoyConfigObjectPatch buildMatchingConfigPatch(io.fabric8.kubernetes.api.builder.Predicate<EnvoyConfigObjectPatchBuilder> predicate){
            for (EnvoyConfigObjectPatchBuilder item: configPatches) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConfigPatch(io.fabric8.kubernetes.api.builder.Predicate<EnvoyConfigObjectPatchBuilder> predicate){
            for (EnvoyConfigObjectPatchBuilder item: configPatches) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConfigPatches(List<EnvoyConfigObjectPatch> configPatches){
            if (this.configPatches != null) { _visitables.get("configPatches").removeAll(this.configPatches);}
            if (configPatches != null) {this.configPatches = new ArrayList<EnvoyConfigObjectPatchBuilder>(); for (EnvoyConfigObjectPatch item : configPatches){this.addToConfigPatches(item);}} else { this.configPatches = null;} return (A) this;
    }

    public A withConfigPatches(EnvoyConfigObjectPatch... configPatches){
            if (this.configPatches != null) {this.configPatches.clear();}
            if (configPatches != null) {for (EnvoyConfigObjectPatch item :configPatches){ this.addToConfigPatches(item);}} return (A) this;
    }

    public Boolean hasConfigPatches(){
            return configPatches != null && !configPatches.isEmpty();
    }

    public EnvoyFilterSpecFluent.ConfigPatchesNested<A> addNewConfigPatch(){
            return new ConfigPatchesNestedImpl();
    }

    public EnvoyFilterSpecFluent.ConfigPatchesNested<A> addNewConfigPatchLike(EnvoyConfigObjectPatch item){
            return new ConfigPatchesNestedImpl(-1, item);
    }

    public EnvoyFilterSpecFluent.ConfigPatchesNested<A> setNewConfigPatchLike(int index,EnvoyConfigObjectPatch item){
            return new ConfigPatchesNestedImpl(index, item);
    }

    public EnvoyFilterSpecFluent.ConfigPatchesNested<A> editConfigPatch(int index){
            if (configPatches.size() <= index) throw new RuntimeException("Can't edit configPatches. Index exceeds size.");
            return setNewConfigPatchLike(index, buildConfigPatch(index));
    }

    public EnvoyFilterSpecFluent.ConfigPatchesNested<A> editFirstConfigPatch(){
            if (configPatches.size() == 0) throw new RuntimeException("Can't edit first configPatches. The list is empty.");
            return setNewConfigPatchLike(0, buildConfigPatch(0));
    }

    public EnvoyFilterSpecFluent.ConfigPatchesNested<A> editLastConfigPatch(){
            int index = configPatches.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last configPatches. The list is empty.");
            return setNewConfigPatchLike(index, buildConfigPatch(index));
    }

    public EnvoyFilterSpecFluent.ConfigPatchesNested<A> editMatchingConfigPatch(io.fabric8.kubernetes.api.builder.Predicate<EnvoyConfigObjectPatchBuilder> predicate){
            int index = -1;
            for (int i=0;i<configPatches.size();i++) { 
            if (predicate.apply(configPatches.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching configPatches. No match found.");
            return setNewConfigPatchLike(index, buildConfigPatch(index));
    }

    
/**
 * This method has been deprecated, please use method buildWorkloadSelector instead.
 * @return The buildable object.
 */
@Deprecated public WorkloadSelector getWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public WorkloadSelector buildWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public A withWorkloadSelector(WorkloadSelector workloadSelector){
            _visitables.get("workloadSelector").remove(this.workloadSelector);
            if (workloadSelector!=null){ this.workloadSelector= new WorkloadSelectorBuilder(workloadSelector); _visitables.get("workloadSelector").add(this.workloadSelector);} return (A) this;
    }

    public Boolean hasWorkloadSelector(){
            return this.workloadSelector != null;
    }

    public EnvoyFilterSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector(){
            return new WorkloadSelectorNestedImpl();
    }

    public EnvoyFilterSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item){
            return new WorkloadSelectorNestedImpl(item);
    }

    public EnvoyFilterSpecFluent.WorkloadSelectorNested<A> editWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector());
    }

    public EnvoyFilterSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): new WorkloadSelectorBuilder().build());
    }

    public EnvoyFilterSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EnvoyFilterSpecFluentImpl that = (EnvoyFilterSpecFluentImpl) o;
            if (configPatches != null ? !configPatches.equals(that.configPatches) :that.configPatches != null) return false;
            if (workloadSelector != null ? !workloadSelector.equals(that.workloadSelector) :that.workloadSelector != null) return false;
            return true;
    }


    public class ConfigPatchesNestedImpl<N> extends EnvoyConfigObjectPatchFluentImpl<EnvoyFilterSpecFluent.ConfigPatchesNested<N>> implements EnvoyFilterSpecFluent.ConfigPatchesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EnvoyConfigObjectPatchBuilder builder;
        private final int index;
    
            ConfigPatchesNestedImpl(int index,EnvoyConfigObjectPatch item){
                    this.index = index;
                    this.builder = new EnvoyConfigObjectPatchBuilder(this, item);
            }
            ConfigPatchesNestedImpl(){
                    this.index = -1;
                    this.builder = new EnvoyConfigObjectPatchBuilder(this);
            }
    
    public N and(){
            return (N) EnvoyFilterSpecFluentImpl.this.setToConfigPatches(index,builder.build());
    }
    public N endConfigPatch(){
            return and();
    }

}
    public class WorkloadSelectorNestedImpl<N> extends WorkloadSelectorFluentImpl<EnvoyFilterSpecFluent.WorkloadSelectorNested<N>> implements EnvoyFilterSpecFluent.WorkloadSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final WorkloadSelectorBuilder builder;
    
            WorkloadSelectorNestedImpl(WorkloadSelector item){
                    this.builder = new WorkloadSelectorBuilder(this, item);
            }
            WorkloadSelectorNestedImpl(){
                    this.builder = new WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) EnvoyFilterSpecFluentImpl.this.withWorkloadSelector(builder.build());
    }
    public N endWorkloadSelector(){
            return and();
    }

}


}
