package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FailoverBuilder extends FailoverFluentImpl<FailoverBuilder> implements VisitableBuilder<Failover,FailoverBuilder>{

    FailoverFluent<?> fluent;
    Boolean validationEnabled;

    public FailoverBuilder(){
            this(true);
    }
    public FailoverBuilder(Boolean validationEnabled){
            this(new Failover(), validationEnabled);
    }
    public FailoverBuilder(FailoverFluent<?> fluent){
            this(fluent, true);
    }
    public FailoverBuilder(FailoverFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Failover(), validationEnabled);
    }
    public FailoverBuilder(FailoverFluent<?> fluent,Failover instance){
            this(fluent, instance, true);
    }
    public FailoverBuilder(FailoverFluent<?> fluent,Failover instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFrom(instance.getFrom()); 
            fluent.withTo(instance.getTo()); 
            this.validationEnabled = validationEnabled; 
    }
    public FailoverBuilder(Failover instance){
            this(instance,true);
    }
    public FailoverBuilder(Failover instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFrom(instance.getFrom()); 
            this.withTo(instance.getTo()); 
            this.validationEnabled = validationEnabled; 
    }

    public Failover build(){
            Failover buildable = new Failover(fluent.getFrom(),fluent.getTo());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FailoverBuilder that = (FailoverBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
