
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "applicationProtocols",
    "filter",
    "name",
    "sni",
    "transportProtocol"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class FilterChainMatch implements Serializable
{

    /**
     * 
     */
    @JsonProperty("applicationProtocols")
    @JsonPropertyDescription("")
    private String applicationProtocols;
    /**
     * 
     */
    @JsonProperty("filter")
    @JsonPropertyDescription("")
    private FilterMatch filter;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("sni")
    @JsonPropertyDescription("")
    private String sni;
    /**
     * 
     */
    @JsonProperty("transportProtocol")
    @JsonPropertyDescription("")
    private String transportProtocol;
    private final static long serialVersionUID = 304224086727873803L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FilterChainMatch() {
    }

    /**
     * 
     * @param filter
     * @param applicationProtocols
     * @param transportProtocol
     * @param name
     * @param sni
     */
    public FilterChainMatch(String applicationProtocols, FilterMatch filter, String name, String sni, String transportProtocol) {
        super();
        this.applicationProtocols = applicationProtocols;
        this.filter = filter;
        this.name = name;
        this.sni = sni;
        this.transportProtocol = transportProtocol;
    }

    /**
     * 
     */
    public String getApplicationProtocols() {
        return applicationProtocols;
    }

    /**
     * 
     */
    public void setApplicationProtocols(String applicationProtocols) {
        this.applicationProtocols = applicationProtocols;
    }

    /**
     * 
     */
    public FilterMatch getFilter() {
        return filter;
    }

    /**
     * 
     */
    public void setFilter(FilterMatch filter) {
        this.filter = filter;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public String getSni() {
        return sni;
    }

    /**
     * 
     */
    public void setSni(String sni) {
        this.sni = sni;
    }

    /**
     * 
     */
    public String getTransportProtocol() {
        return transportProtocol;
    }

    /**
     * 
     */
    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

}
