package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FilterChainMatchBuilder extends FilterChainMatchFluentImpl<FilterChainMatchBuilder> implements VisitableBuilder<FilterChainMatch,FilterChainMatchBuilder>{

    FilterChainMatchFluent<?> fluent;
    Boolean validationEnabled;

    public FilterChainMatchBuilder(){
            this(true);
    }
    public FilterChainMatchBuilder(Boolean validationEnabled){
            this(new FilterChainMatch(), validationEnabled);
    }
    public FilterChainMatchBuilder(FilterChainMatchFluent<?> fluent){
            this(fluent, true);
    }
    public FilterChainMatchBuilder(FilterChainMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new FilterChainMatch(), validationEnabled);
    }
    public FilterChainMatchBuilder(FilterChainMatchFluent<?> fluent,FilterChainMatch instance){
            this(fluent, instance, true);
    }
    public FilterChainMatchBuilder(FilterChainMatchFluent<?> fluent,FilterChainMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApplicationProtocols(instance.getApplicationProtocols()); 
            fluent.withFilter(instance.getFilter()); 
            fluent.withName(instance.getName()); 
            fluent.withSni(instance.getSni()); 
            fluent.withTransportProtocol(instance.getTransportProtocol()); 
            this.validationEnabled = validationEnabled; 
    }
    public FilterChainMatchBuilder(FilterChainMatch instance){
            this(instance,true);
    }
    public FilterChainMatchBuilder(FilterChainMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApplicationProtocols(instance.getApplicationProtocols()); 
            this.withFilter(instance.getFilter()); 
            this.withName(instance.getName()); 
            this.withSni(instance.getSni()); 
            this.withTransportProtocol(instance.getTransportProtocol()); 
            this.validationEnabled = validationEnabled; 
    }

    public FilterChainMatch build(){
            FilterChainMatch buildable = new FilterChainMatch(fluent.getApplicationProtocols(),fluent.getFilter(),fluent.getName(),fluent.getSni(),fluent.getTransportProtocol());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FilterChainMatchBuilder that = (FilterChainMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
