package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class FilterChainMatchFluentImpl<A extends FilterChainMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FilterChainMatchFluent<A>{

    private String applicationProtocols;
    private FilterMatchBuilder filter;
    private String name;
    private String sni;
    private String transportProtocol;

    public FilterChainMatchFluentImpl(){
    }
    public FilterChainMatchFluentImpl(FilterChainMatch instance){
            this.withApplicationProtocols(instance.getApplicationProtocols()); 
            this.withFilter(instance.getFilter()); 
            this.withName(instance.getName()); 
            this.withSni(instance.getSni()); 
            this.withTransportProtocol(instance.getTransportProtocol()); 
    }

    public String getApplicationProtocols(){
            return this.applicationProtocols;
    }

    public A withApplicationProtocols(String applicationProtocols){
            this.applicationProtocols=applicationProtocols; return (A) this;
    }

    public Boolean hasApplicationProtocols(){
            return this.applicationProtocols != null;
    }

    public A withNewApplicationProtocols(String arg1){
            return (A)withApplicationProtocols(new String(arg1));
    }

    public A withNewApplicationProtocols(StringBuilder arg1){
            return (A)withApplicationProtocols(new String(arg1));
    }

    public A withNewApplicationProtocols(StringBuffer arg1){
            return (A)withApplicationProtocols(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFilter instead.
 * @return The buildable object.
 */
@Deprecated public FilterMatch getFilter(){
            return this.filter!=null?this.filter.build():null;
    }

    public FilterMatch buildFilter(){
            return this.filter!=null?this.filter.build():null;
    }

    public A withFilter(FilterMatch filter){
            _visitables.get("filter").remove(this.filter);
            if (filter!=null){ this.filter= new FilterMatchBuilder(filter); _visitables.get("filter").add(this.filter);} return (A) this;
    }

    public Boolean hasFilter(){
            return this.filter != null;
    }

    public FilterChainMatchFluent.FilterNested<A> withNewFilter(){
            return new FilterNestedImpl();
    }

    public FilterChainMatchFluent.FilterNested<A> withNewFilterLike(FilterMatch item){
            return new FilterNestedImpl(item);
    }

    public FilterChainMatchFluent.FilterNested<A> editFilter(){
            return withNewFilterLike(getFilter());
    }

    public FilterChainMatchFluent.FilterNested<A> editOrNewFilter(){
            return withNewFilterLike(getFilter() != null ? getFilter(): new FilterMatchBuilder().build());
    }

    public FilterChainMatchFluent.FilterNested<A> editOrNewFilterLike(FilterMatch item){
            return withNewFilterLike(getFilter() != null ? getFilter(): item);
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getSni(){
            return this.sni;
    }

    public A withSni(String sni){
            this.sni=sni; return (A) this;
    }

    public Boolean hasSni(){
            return this.sni != null;
    }

    public A withNewSni(String arg1){
            return (A)withSni(new String(arg1));
    }

    public A withNewSni(StringBuilder arg1){
            return (A)withSni(new String(arg1));
    }

    public A withNewSni(StringBuffer arg1){
            return (A)withSni(new String(arg1));
    }

    public String getTransportProtocol(){
            return this.transportProtocol;
    }

    public A withTransportProtocol(String transportProtocol){
            this.transportProtocol=transportProtocol; return (A) this;
    }

    public Boolean hasTransportProtocol(){
            return this.transportProtocol != null;
    }

    public A withNewTransportProtocol(String arg1){
            return (A)withTransportProtocol(new String(arg1));
    }

    public A withNewTransportProtocol(StringBuilder arg1){
            return (A)withTransportProtocol(new String(arg1));
    }

    public A withNewTransportProtocol(StringBuffer arg1){
            return (A)withTransportProtocol(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            FilterChainMatchFluentImpl that = (FilterChainMatchFluentImpl) o;
            if (applicationProtocols != null ? !applicationProtocols.equals(that.applicationProtocols) :that.applicationProtocols != null) return false;
            if (filter != null ? !filter.equals(that.filter) :that.filter != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (sni != null ? !sni.equals(that.sni) :that.sni != null) return false;
            if (transportProtocol != null ? !transportProtocol.equals(that.transportProtocol) :that.transportProtocol != null) return false;
            return true;
    }


    public class FilterNestedImpl<N> extends FilterMatchFluentImpl<FilterChainMatchFluent.FilterNested<N>> implements FilterChainMatchFluent.FilterNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FilterMatchBuilder builder;
    
            FilterNestedImpl(FilterMatch item){
                    this.builder = new FilterMatchBuilder(this, item);
            }
            FilterNestedImpl(){
                    this.builder = new FilterMatchBuilder(this);
            }
    
    public N and(){
            return (N) FilterChainMatchFluentImpl.this.withFilter(builder.build());
    }
    public N endFilter(){
            return and();
    }

}


}
