package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class FilterMatchFluentImpl<A extends FilterMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FilterMatchFluent<A>{

    private String name;
    private SubFilterMatchBuilder subFilter;

    public FilterMatchFluentImpl(){
    }
    public FilterMatchFluentImpl(FilterMatch instance){
            this.withName(instance.getName()); 
            this.withSubFilter(instance.getSubFilter()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSubFilter instead.
 * @return The buildable object.
 */
@Deprecated public SubFilterMatch getSubFilter(){
            return this.subFilter!=null?this.subFilter.build():null;
    }

    public SubFilterMatch buildSubFilter(){
            return this.subFilter!=null?this.subFilter.build():null;
    }

    public A withSubFilter(SubFilterMatch subFilter){
            _visitables.get("subFilter").remove(this.subFilter);
            if (subFilter!=null){ this.subFilter= new SubFilterMatchBuilder(subFilter); _visitables.get("subFilter").add(this.subFilter);} return (A) this;
    }

    public Boolean hasSubFilter(){
            return this.subFilter != null;
    }

    public A withNewSubFilter(String name){
            return (A)withSubFilter(new SubFilterMatch(name));
    }

    public FilterMatchFluent.SubFilterNested<A> withNewSubFilter(){
            return new SubFilterNestedImpl();
    }

    public FilterMatchFluent.SubFilterNested<A> withNewSubFilterLike(SubFilterMatch item){
            return new SubFilterNestedImpl(item);
    }

    public FilterMatchFluent.SubFilterNested<A> editSubFilter(){
            return withNewSubFilterLike(getSubFilter());
    }

    public FilterMatchFluent.SubFilterNested<A> editOrNewSubFilter(){
            return withNewSubFilterLike(getSubFilter() != null ? getSubFilter(): new SubFilterMatchBuilder().build());
    }

    public FilterMatchFluent.SubFilterNested<A> editOrNewSubFilterLike(SubFilterMatch item){
            return withNewSubFilterLike(getSubFilter() != null ? getSubFilter(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            FilterMatchFluentImpl that = (FilterMatchFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (subFilter != null ? !subFilter.equals(that.subFilter) :that.subFilter != null) return false;
            return true;
    }


    public class SubFilterNestedImpl<N> extends SubFilterMatchFluentImpl<FilterMatchFluent.SubFilterNested<N>> implements FilterMatchFluent.SubFilterNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubFilterMatchBuilder builder;
    
            SubFilterNestedImpl(SubFilterMatch item){
                    this.builder = new SubFilterMatchBuilder(this, item);
            }
            SubFilterNestedImpl(){
                    this.builder = new SubFilterMatchBuilder(this);
            }
    
    public N and(){
            return (N) FilterMatchFluentImpl.this.withSubFilter(builder.build());
    }
    public N endSubFilter(){
            return and();
    }

}


}
