
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "grpcStatus"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class GrpcStatusErrorType implements Serializable, ErrorType
{

    /**
     * 
     */
    @JsonProperty("grpcStatus")
    @JsonPropertyDescription("")
    private String grpcStatus;
    private final static long serialVersionUID = 6311081885976139962L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GrpcStatusErrorType() {
    }

    /**
     * 
     * @param grpcStatus
     */
    public GrpcStatusErrorType(String grpcStatus) {
        super();
        this.grpcStatus = grpcStatus;
    }

    /**
     * 
     */
    public String getGrpcStatus() {
        return grpcStatus;
    }

    /**
     * 
     */
    public void setGrpcStatus(String grpcStatus) {
        this.grpcStatus = grpcStatus;
    }

}
