
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "authority",
    "gateways",
    "headers",
    "ignoreUriCase",
    "method",
    "name",
    "port",
    "queryParams",
    "scheme",
    "sourceLabels",
    "sourceNamespace",
    "uri",
    "withoutHeaders"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPMatchRequest implements Serializable
{

    /**
     * 
     */
    @JsonProperty("authority")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch authority;
    /**
     * 
     */
    @JsonProperty("gateways")
    @JsonPropertyDescription("")
    private List<java.lang.String> gateways = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("headers")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> headers;
    /**
     * 
     */
    @JsonProperty("ignoreUriCase")
    @JsonPropertyDescription("")
    private Boolean ignoreUriCase;
    /**
     * 
     */
    @JsonProperty("method")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch method;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Integer port;
    /**
     * 
     */
    @JsonProperty("queryParams")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> queryParams;
    /**
     * 
     */
    @JsonProperty("scheme")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch scheme;
    /**
     * 
     */
    @JsonProperty("sourceLabels")
    @JsonPropertyDescription("")
    private Map<String, String> sourceLabels;
    /**
     * 
     */
    @JsonProperty("sourceNamespace")
    @JsonPropertyDescription("")
    private java.lang.String sourceNamespace;
    /**
     * 
     */
    @JsonProperty("uri")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch uri;
    /**
     * 
     */
    @JsonProperty("withoutHeaders")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> withoutHeaders;
    private final static long serialVersionUID = 2476158308611883993L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPMatchRequest() {
    }

    /**
     * 
     * @param gateways
     * @param headers
     * @param method
     * @param scheme
     * @param queryParams
     * @param sourceLabels
     * @param uri
     * @param ignoreUriCase
     * @param port
     * @param authority
     * @param name
     * @param sourceNamespace
     * @param withoutHeaders
     */
    public HTTPMatchRequest(me.snowdrop.istio.api.networking.v1alpha3.StringMatch authority, List<java.lang.String> gateways, Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> headers, Boolean ignoreUriCase, me.snowdrop.istio.api.networking.v1alpha3.StringMatch method, java.lang.String name, Integer port, Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> queryParams, me.snowdrop.istio.api.networking.v1alpha3.StringMatch scheme, Map<String, String> sourceLabels, java.lang.String sourceNamespace, me.snowdrop.istio.api.networking.v1alpha3.StringMatch uri, Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> withoutHeaders) {
        super();
        this.authority = authority;
        this.gateways = gateways;
        this.headers = headers;
        this.ignoreUriCase = ignoreUriCase;
        this.method = method;
        this.name = name;
        this.port = port;
        this.queryParams = queryParams;
        this.scheme = scheme;
        this.sourceLabels = sourceLabels;
        this.sourceNamespace = sourceNamespace;
        this.uri = uri;
        this.withoutHeaders = withoutHeaders;
    }

    /**
     * 
     */
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getAuthority() {
        return authority;
    }

    /**
     * 
     */
    public void setAuthority(me.snowdrop.istio.api.networking.v1alpha3.StringMatch authority) {
        this.authority = authority;
    }

    /**
     * 
     */
    public List<java.lang.String> getGateways() {
        return gateways;
    }

    /**
     * 
     */
    public void setGateways(List<java.lang.String> gateways) {
        this.gateways = gateways;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> getHeaders() {
        return headers;
    }

    /**
     * 
     */
    public void setHeaders(Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> headers) {
        this.headers = headers;
    }

    /**
     * 
     */
    public Boolean getIgnoreUriCase() {
        return ignoreUriCase;
    }

    /**
     * 
     */
    public void setIgnoreUriCase(Boolean ignoreUriCase) {
        this.ignoreUriCase = ignoreUriCase;
    }

    /**
     * 
     */
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getMethod() {
        return method;
    }

    /**
     * 
     */
    public void setMethod(me.snowdrop.istio.api.networking.v1alpha3.StringMatch method) {
        this.method = method;
    }

    /**
     * 
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     */
    public Integer getPort() {
        return port;
    }

    /**
     * 
     */
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> getQueryParams() {
        return queryParams;
    }

    /**
     * 
     */
    public void setQueryParams(Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> queryParams) {
        this.queryParams = queryParams;
    }

    /**
     * 
     */
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getScheme() {
        return scheme;
    }

    /**
     * 
     */
    public void setScheme(me.snowdrop.istio.api.networking.v1alpha3.StringMatch scheme) {
        this.scheme = scheme;
    }

    /**
     * 
     */
    public Map<String, String> getSourceLabels() {
        return sourceLabels;
    }

    /**
     * 
     */
    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    /**
     * 
     */
    public java.lang.String getSourceNamespace() {
        return sourceNamespace;
    }

    /**
     * 
     */
    public void setSourceNamespace(java.lang.String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
    }

    /**
     * 
     */
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getUri() {
        return uri;
    }

    /**
     * 
     */
    public void setUri(me.snowdrop.istio.api.networking.v1alpha3.StringMatch uri) {
        this.uri = uri;
    }

    /**
     * 
     */
    public Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> getWithoutHeaders() {
        return withoutHeaders;
    }

    /**
     * 
     */
    public void setWithoutHeaders(Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> withoutHeaders) {
        this.withoutHeaders = withoutHeaders;
    }

}
