
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "authority",
    "redirectCode",
    "uri"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRedirect implements Serializable
{

    /**
     * 
     */
    @JsonProperty("authority")
    @JsonPropertyDescription("")
    private String authority;
    /**
     * 
     */
    @JsonProperty("redirectCode")
    @JsonPropertyDescription("")
    private Integer redirectCode;
    /**
     * 
     */
    @JsonProperty("uri")
    @JsonPropertyDescription("")
    private String uri;
    private final static long serialVersionUID = 230158236520509308L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRedirect() {
    }

    /**
     * 
     * @param authority
     * @param redirectCode
     * @param uri
     */
    public HTTPRedirect(String authority, Integer redirectCode, String uri) {
        super();
        this.authority = authority;
        this.redirectCode = redirectCode;
        this.uri = uri;
    }

    /**
     * 
     */
    public String getAuthority() {
        return authority;
    }

    /**
     * 
     */
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    /**
     * 
     */
    public Integer getRedirectCode() {
        return redirectCode;
    }

    /**
     * 
     */
    public void setRedirectCode(Integer redirectCode) {
        this.redirectCode = redirectCode;
    }

    /**
     * 
     */
    public String getUri() {
        return uri;
    }

    /**
     * 
     */
    public void setUri(String uri) {
        this.uri = uri;
    }

}
