package me.snowdrop.istio.api.networking.v1alpha3;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class HTTPRedirectFluentImpl<A extends HTTPRedirectFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPRedirectFluent<A>{

    private String authority;
    private Integer redirectCode;
    private String uri;

    public HTTPRedirectFluentImpl(){
    }
    public HTTPRedirectFluentImpl(HTTPRedirect instance){
            this.withAuthority(instance.getAuthority()); 
            this.withRedirectCode(instance.getRedirectCode()); 
            this.withUri(instance.getUri()); 
    }

    public String getAuthority(){
            return this.authority;
    }

    public A withAuthority(String authority){
            this.authority=authority; return (A) this;
    }

    public Boolean hasAuthority(){
            return this.authority != null;
    }

    public A withNewAuthority(String arg1){
            return (A)withAuthority(new String(arg1));
    }

    public A withNewAuthority(StringBuilder arg1){
            return (A)withAuthority(new String(arg1));
    }

    public A withNewAuthority(StringBuffer arg1){
            return (A)withAuthority(new String(arg1));
    }

    public Integer getRedirectCode(){
            return this.redirectCode;
    }

    public A withRedirectCode(Integer redirectCode){
            this.redirectCode=redirectCode; return (A) this;
    }

    public Boolean hasRedirectCode(){
            return this.redirectCode != null;
    }

    public String getUri(){
            return this.uri;
    }

    public A withUri(String uri){
            this.uri=uri; return (A) this;
    }

    public Boolean hasUri(){
            return this.uri != null;
    }

    public A withNewUri(String arg1){
            return (A)withUri(new String(arg1));
    }

    public A withNewUri(StringBuilder arg1){
            return (A)withUri(new String(arg1));
    }

    public A withNewUri(StringBuffer arg1){
            return (A)withUri(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPRedirectFluentImpl that = (HTTPRedirectFluentImpl) o;
            if (authority != null ? !authority.equals(that.authority) :that.authority != null) return false;
            if (redirectCode != null ? !redirectCode.equals(that.redirectCode) :that.redirectCode != null) return false;
            if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
            return true;
    }




}
