
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attempts",
    "perTryTimeout",
    "retryOn",
    "retryRemoteLocalities"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRetry implements Serializable
{

    /**
     * 
     */
    @JsonProperty("attempts")
    @JsonPropertyDescription("")
    private Integer attempts;
    /**
     * 
     */
    @JsonProperty("perTryTimeout")
    @JsonPropertyDescription("")
    private Duration perTryTimeout;
    /**
     * 
     */
    @JsonProperty("retryOn")
    @JsonPropertyDescription("")
    private String retryOn;
    @JsonProperty("retryRemoteLocalities")
    private Boolean retryRemoteLocalities;
    private final static long serialVersionUID = -7905449641564284756L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRetry() {
    }

    /**
     * 
     * @param perTryTimeout
     * @param retryRemoteLocalities
     * @param attempts
     * @param retryOn
     */
    public HTTPRetry(Integer attempts, Duration perTryTimeout, String retryOn, Boolean retryRemoteLocalities) {
        super();
        this.attempts = attempts;
        this.perTryTimeout = perTryTimeout;
        this.retryOn = retryOn;
        this.retryRemoteLocalities = retryRemoteLocalities;
    }

    /**
     * 
     */
    public Integer getAttempts() {
        return attempts;
    }

    /**
     * 
     */
    public void setAttempts(Integer attempts) {
        this.attempts = attempts;
    }

    /**
     * 
     */
    public Duration getPerTryTimeout() {
        return perTryTimeout;
    }

    /**
     * 
     */
    public void setPerTryTimeout(Duration perTryTimeout) {
        this.perTryTimeout = perTryTimeout;
    }

    /**
     * 
     */
    public String getRetryOn() {
        return retryOn;
    }

    /**
     * 
     */
    public void setRetryOn(String retryOn) {
        this.retryOn = retryOn;
    }

    public Boolean getRetryRemoteLocalities() {
        return retryRemoteLocalities;
    }

    public void setRetryRemoteLocalities(Boolean retryRemoteLocalities) {
        this.retryRemoteLocalities = retryRemoteLocalities;
    }

}
