package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import me.snowdrop.istio.api.DurationBuilder;

public interface HTTPRetryFluent<A extends HTTPRetryFluent<A>> extends Fluent<A>{


    public Integer getAttempts();
    public A withAttempts(Integer attempts);
    public Boolean hasAttempts();
    
/**
 * This method has been deprecated, please use method buildPerTryTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getPerTryTimeout();
    public Duration buildPerTryTimeout();
    public A withPerTryTimeout(Duration perTryTimeout);
    public Boolean hasPerTryTimeout();
    public A withNewPerTryTimeout(Integer nanos,Long seconds);
    public HTTPRetryFluent.PerTryTimeoutNested<A> withNewPerTryTimeout();
    public HTTPRetryFluent.PerTryTimeoutNested<A> withNewPerTryTimeoutLike(Duration item);
    public HTTPRetryFluent.PerTryTimeoutNested<A> editPerTryTimeout();
    public HTTPRetryFluent.PerTryTimeoutNested<A> editOrNewPerTryTimeout();
    public HTTPRetryFluent.PerTryTimeoutNested<A> editOrNewPerTryTimeoutLike(Duration item);
    public String getRetryOn();
    public A withRetryOn(String retryOn);
    public Boolean hasRetryOn();
    public A withNewRetryOn(String arg1);
    public A withNewRetryOn(StringBuilder arg1);
    public A withNewRetryOn(StringBuffer arg1);
    public Boolean isRetryRemoteLocalities();
    public A withRetryRemoteLocalities(Boolean retryRemoteLocalities);
    public Boolean hasRetryRemoteLocalities();
    public A withNewRetryRemoteLocalities(String arg1);
    public A withNewRetryRemoteLocalities(boolean arg1);

    public interface PerTryTimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<HTTPRetryFluent.PerTryTimeoutNested<N>>{

        
    public N and();    public N endPerTryTimeout();
}


}
