
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "corsPolicy",
    "delegate",
    "fault",
    "headers",
    "match",
    "mirror",
    "mirrorPercent",
    "mirrorPercentage",
    "name",
    "redirect",
    "retries",
    "rewrite",
    "route",
    "timeout"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRoute implements Serializable
{

    /**
     * 
     */
    @JsonProperty("corsPolicy")
    @JsonPropertyDescription("")
    private CorsPolicy corsPolicy;
    /**
     * 
     */
    @JsonProperty("delegate")
    @JsonPropertyDescription("")
    private Delegate delegate;
    /**
     * 
     */
    @JsonProperty("fault")
    @JsonPropertyDescription("")
    private HTTPFaultInjection fault;
    /**
     * 
     */
    @JsonProperty("headers")
    @JsonPropertyDescription("")
    private Headers headers;
    /**
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    private List<HTTPMatchRequest> match = new ArrayList<HTTPMatchRequest>();
    /**
     * 
     */
    @JsonProperty("mirror")
    @JsonPropertyDescription("")
    private Destination mirror;
    @JsonProperty("mirrorPercent")
    private Integer mirrorPercent;
    /**
     * 
     */
    @JsonProperty("mirrorPercentage")
    @JsonPropertyDescription("")
    private Percent mirrorPercentage;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("redirect")
    @JsonPropertyDescription("")
    private HTTPRedirect redirect;
    /**
     * 
     */
    @JsonProperty("retries")
    @JsonPropertyDescription("")
    private HTTPRetry retries;
    /**
     * 
     */
    @JsonProperty("rewrite")
    @JsonPropertyDescription("")
    private HTTPRewrite rewrite;
    /**
     * 
     */
    @JsonProperty("route")
    @JsonPropertyDescription("")
    private List<HTTPRouteDestination> route = new ArrayList<HTTPRouteDestination>();
    /**
     * 
     */
    @JsonProperty("timeout")
    @JsonPropertyDescription("")
    private Duration timeout;
    private final static long serialVersionUID = -2894814953283372487L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRoute() {
    }

    /**
     * 
     * @param redirect
     * @param headers
     * @param mirror
     * @param mirrorPercent
     * @param corsPolicy
     * @param match
     * @param fault
     * @param mirrorPercentage
     * @param rewrite
     * @param timeout
     * @param delegate
     * @param retries
     * @param route
     * @param name
     */
    public HTTPRoute(CorsPolicy corsPolicy, Delegate delegate, HTTPFaultInjection fault, Headers headers, List<HTTPMatchRequest> match, Destination mirror, Integer mirrorPercent, Percent mirrorPercentage, String name, HTTPRedirect redirect, HTTPRetry retries, HTTPRewrite rewrite, List<HTTPRouteDestination> route, Duration timeout) {
        super();
        this.corsPolicy = corsPolicy;
        this.delegate = delegate;
        this.fault = fault;
        this.headers = headers;
        this.match = match;
        this.mirror = mirror;
        this.mirrorPercent = mirrorPercent;
        this.mirrorPercentage = mirrorPercentage;
        this.name = name;
        this.redirect = redirect;
        this.retries = retries;
        this.rewrite = rewrite;
        this.route = route;
        this.timeout = timeout;
    }

    /**
     * 
     */
    public CorsPolicy getCorsPolicy() {
        return corsPolicy;
    }

    /**
     * 
     */
    public void setCorsPolicy(CorsPolicy corsPolicy) {
        this.corsPolicy = corsPolicy;
    }

    /**
     * 
     */
    public Delegate getDelegate() {
        return delegate;
    }

    /**
     * 
     */
    public void setDelegate(Delegate delegate) {
        this.delegate = delegate;
    }

    /**
     * 
     */
    public HTTPFaultInjection getFault() {
        return fault;
    }

    /**
     * 
     */
    public void setFault(HTTPFaultInjection fault) {
        this.fault = fault;
    }

    /**
     * 
     */
    public Headers getHeaders() {
        return headers;
    }

    /**
     * 
     */
    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    /**
     * 
     */
    public List<HTTPMatchRequest> getMatch() {
        return match;
    }

    /**
     * 
     */
    public void setMatch(List<HTTPMatchRequest> match) {
        this.match = match;
    }

    /**
     * 
     */
    public Destination getMirror() {
        return mirror;
    }

    /**
     * 
     */
    public void setMirror(Destination mirror) {
        this.mirror = mirror;
    }

    public Integer getMirrorPercent() {
        return mirrorPercent;
    }

    public void setMirrorPercent(Integer mirrorPercent) {
        this.mirrorPercent = mirrorPercent;
    }

    /**
     * 
     */
    public Percent getMirrorPercentage() {
        return mirrorPercentage;
    }

    /**
     * 
     */
    public void setMirrorPercentage(Percent mirrorPercentage) {
        this.mirrorPercentage = mirrorPercentage;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public HTTPRedirect getRedirect() {
        return redirect;
    }

    /**
     * 
     */
    public void setRedirect(HTTPRedirect redirect) {
        this.redirect = redirect;
    }

    /**
     * 
     */
    public HTTPRetry getRetries() {
        return retries;
    }

    /**
     * 
     */
    public void setRetries(HTTPRetry retries) {
        this.retries = retries;
    }

    /**
     * 
     */
    public HTTPRewrite getRewrite() {
        return rewrite;
    }

    /**
     * 
     */
    public void setRewrite(HTTPRewrite rewrite) {
        this.rewrite = rewrite;
    }

    /**
     * 
     */
    public List<HTTPRouteDestination> getRoute() {
        return route;
    }

    /**
     * 
     */
    public void setRoute(List<HTTPRouteDestination> route) {
        this.route = route;
    }

    /**
     * 
     */
    public Duration getTimeout() {
        return timeout;
    }

    /**
     * 
     */
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

}
