
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "destination",
    "headers",
    "weight"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRouteDestination implements Serializable
{

    /**
     * 
     */
    @JsonProperty("destination")
    @JsonPropertyDescription("")
    private Destination destination;
    /**
     * 
     */
    @JsonProperty("headers")
    @JsonPropertyDescription("")
    private Headers headers;
    /**
     * 
     */
    @JsonProperty("weight")
    @JsonPropertyDescription("")
    private Integer weight;
    private final static long serialVersionUID = 2779057818019837631L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRouteDestination() {
    }

    /**
     * 
     * @param headers
     * @param destination
     * @param weight
     */
    public HTTPRouteDestination(Destination destination, Headers headers, Integer weight) {
        super();
        this.destination = destination;
        this.headers = headers;
        this.weight = weight;
    }

    /**
     * 
     */
    public Destination getDestination() {
        return destination;
    }

    /**
     * 
     */
    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    /**
     * 
     */
    public Headers getHeaders() {
        return headers;
    }

    /**
     * 
     */
    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    /**
     * 
     */
    public Integer getWeight() {
        return weight;
    }

    /**
     * 
     */
    public void setWeight(Integer weight) {
        this.weight = weight;
    }

}
