package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import me.snowdrop.istio.api.DurationFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.Duration;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationBuilder;

public interface HTTPSettingsFluent<A extends HTTPSettingsFluent<A>> extends Fluent<A>{


    public me.snowdrop.istio.api.networking.v1alpha3.H2UpgradePolicy getH2UpgradePolicy();
    public A withH2UpgradePolicy(me.snowdrop.istio.api.networking.v1alpha3.H2UpgradePolicy h2UpgradePolicy);
    public Boolean hasH2UpgradePolicy();
    public Integer getHttp1MaxPendingRequests();
    public A withHttp1MaxPendingRequests(Integer http1MaxPendingRequests);
    public Boolean hasHttp1MaxPendingRequests();
    public Integer getHttp2MaxRequests();
    public A withHttp2MaxRequests(Integer http2MaxRequests);
    public Boolean hasHttp2MaxRequests();
    
/**
 * This method has been deprecated, please use method buildIdleTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getIdleTimeout();
    public Duration buildIdleTimeout();
    public A withIdleTimeout(Duration idleTimeout);
    public Boolean hasIdleTimeout();
    public A withNewIdleTimeout(Integer nanos,Long seconds);
    public HTTPSettingsFluent.IdleTimeoutNested<A> withNewIdleTimeout();
    public HTTPSettingsFluent.IdleTimeoutNested<A> withNewIdleTimeoutLike(Duration item);
    public HTTPSettingsFluent.IdleTimeoutNested<A> editIdleTimeout();
    public HTTPSettingsFluent.IdleTimeoutNested<A> editOrNewIdleTimeout();
    public HTTPSettingsFluent.IdleTimeoutNested<A> editOrNewIdleTimeoutLike(Duration item);
    public Integer getMaxRequestsPerConnection();
    public A withMaxRequestsPerConnection(Integer maxRequestsPerConnection);
    public Boolean hasMaxRequestsPerConnection();
    public Integer getMaxRetries();
    public A withMaxRetries(Integer maxRetries);
    public Boolean hasMaxRetries();

    public interface IdleTimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<HTTPSettingsFluent.IdleTimeoutNested<N>>{

        
    public N and();    public N endIdleTimeout();
}


}
