
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "request",
    "response"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Headers implements Serializable
{

    /**
     * 
     */
    @JsonProperty("request")
    @JsonPropertyDescription("")
    private HeaderOperations request;
    /**
     * 
     */
    @JsonProperty("response")
    @JsonPropertyDescription("")
    private HeaderOperations response;
    private final static long serialVersionUID = 8151838754263113315L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Headers() {
    }

    /**
     * 
     * @param request
     * @param response
     */
    public Headers(HeaderOperations request, HeaderOperations response) {
        super();
        this.request = request;
        this.response = response;
    }

    /**
     * 
     */
    public HeaderOperations getRequest() {
        return request;
    }

    /**
     * 
     */
    public void setRequest(HeaderOperations request) {
        this.request = request;
    }

    /**
     * 
     */
    public HeaderOperations getResponse() {
        return response;
    }

    /**
     * 
     */
    public void setResponse(HeaderOperations response) {
        this.response = response;
    }

}
