package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HeadersBuilder extends HeadersFluentImpl<HeadersBuilder> implements VisitableBuilder<Headers,HeadersBuilder>{

    HeadersFluent<?> fluent;
    Boolean validationEnabled;

    public HeadersBuilder(){
            this(true);
    }
    public HeadersBuilder(Boolean validationEnabled){
            this(new Headers(), validationEnabled);
    }
    public HeadersBuilder(HeadersFluent<?> fluent){
            this(fluent, true);
    }
    public HeadersBuilder(HeadersFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Headers(), validationEnabled);
    }
    public HeadersBuilder(HeadersFluent<?> fluent,Headers instance){
            this(fluent, instance, true);
    }
    public HeadersBuilder(HeadersFluent<?> fluent,Headers instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRequest(instance.getRequest()); 
            fluent.withResponse(instance.getResponse()); 
            this.validationEnabled = validationEnabled; 
    }
    public HeadersBuilder(Headers instance){
            this(instance,true);
    }
    public HeadersBuilder(Headers instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRequest(instance.getRequest()); 
            this.withResponse(instance.getResponse()); 
            this.validationEnabled = validationEnabled; 
    }

    public Headers build(){
            Headers buildable = new Headers(fluent.getRequest(),fluent.getResponse());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HeadersBuilder that = (HeadersBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
