package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface IstioEgressListenerFluent<A extends IstioEgressListenerFluent<A>> extends Fluent<A>{


    public String getBind();
    public A withBind(String bind);
    public Boolean hasBind();
    public A withNewBind(String arg1);
    public A withNewBind(StringBuilder arg1);
    public A withNewBind(StringBuffer arg1);
    public CaptureMode getCaptureMode();
    public A withCaptureMode(CaptureMode captureMode);
    public Boolean hasCaptureMode();
    public A addToHosts(int index,String item);
    public A setToHosts(int index,String item);
    public A addToHosts(String... items);
    public A addAllToHosts(Collection<String> items);
    public A removeFromHosts(String... items);
    public A removeAllFromHosts(Collection<String> items);
    public List<String> getHosts();
    public String getHost(int index);
    public String getFirstHost();
    public String getLastHost();
    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withHosts(List<String> hosts);
    public A withHosts(String... hosts);
    public Boolean hasHosts();
    public A addNewHost(String arg1);
    public A addNewHost(StringBuilder arg1);
    public A addNewHost(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public Port getPort();
    public Port buildPort();
    public A withPort(Port port);
    public Boolean hasPort();
    public A withNewPort(String name,Integer number,String protocol,Integer targetPort);
    public IstioEgressListenerFluent.PortNested<A> withNewPort();
    public IstioEgressListenerFluent.PortNested<A> withNewPortLike(Port item);
    public IstioEgressListenerFluent.PortNested<A> editPort();
    public IstioEgressListenerFluent.PortNested<A> editOrNewPort();
    public IstioEgressListenerFluent.PortNested<A> editOrNewPortLike(Port item);

    public interface PortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PortFluent<IstioEgressListenerFluent.PortNested<N>>{

        
    public N and();    public N endPort();
}


}
