
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "destinationSubnets",
    "gateways",
    "port",
    "sourceLabels",
    "sourceNamespace",
    "sourceSubnet"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class L4MatchAttributes implements Serializable
{

    /**
     * 
     */
    @JsonProperty("destinationSubnets")
    @JsonPropertyDescription("")
    private List<java.lang.String> destinationSubnets = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("gateways")
    @JsonPropertyDescription("")
    private List<java.lang.String> gateways = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Integer port;
    /**
     * 
     */
    @JsonProperty("sourceLabels")
    @JsonPropertyDescription("")
    private Map<String, String> sourceLabels;
    /**
     * 
     */
    @JsonProperty("sourceNamespace")
    @JsonPropertyDescription("")
    private java.lang.String sourceNamespace;
    /**
     * 
     */
    @JsonProperty("sourceSubnet")
    @JsonPropertyDescription("")
    private java.lang.String sourceSubnet;
    private final static long serialVersionUID = 5208044470596675764L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public L4MatchAttributes() {
    }

    /**
     * 
     * @param gateways
     * @param destinationSubnets
     * @param sourceSubnet
     * @param port
     * @param sourceLabels
     * @param sourceNamespace
     */
    public L4MatchAttributes(List<java.lang.String> destinationSubnets, List<java.lang.String> gateways, Integer port, Map<String, String> sourceLabels, java.lang.String sourceNamespace, java.lang.String sourceSubnet) {
        super();
        this.destinationSubnets = destinationSubnets;
        this.gateways = gateways;
        this.port = port;
        this.sourceLabels = sourceLabels;
        this.sourceNamespace = sourceNamespace;
        this.sourceSubnet = sourceSubnet;
    }

    /**
     * 
     */
    public List<java.lang.String> getDestinationSubnets() {
        return destinationSubnets;
    }

    /**
     * 
     */
    public void setDestinationSubnets(List<java.lang.String> destinationSubnets) {
        this.destinationSubnets = destinationSubnets;
    }

    /**
     * 
     */
    public List<java.lang.String> getGateways() {
        return gateways;
    }

    /**
     * 
     */
    public void setGateways(List<java.lang.String> gateways) {
        this.gateways = gateways;
    }

    /**
     * 
     */
    public Integer getPort() {
        return port;
    }

    /**
     * 
     */
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * 
     */
    public Map<String, String> getSourceLabels() {
        return sourceLabels;
    }

    /**
     * 
     */
    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    /**
     * 
     */
    public java.lang.String getSourceNamespace() {
        return sourceNamespace;
    }

    /**
     * 
     */
    public void setSourceNamespace(java.lang.String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
    }

    /**
     * 
     */
    public java.lang.String getSourceSubnet() {
        return sourceSubnet;
    }

    /**
     * 
     */
    public void setSourceSubnet(java.lang.String sourceSubnet) {
        this.sourceSubnet = sourceSubnet;
    }

}
