package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class L4MatchAttributesBuilder extends L4MatchAttributesFluentImpl<L4MatchAttributesBuilder> implements VisitableBuilder<L4MatchAttributes,L4MatchAttributesBuilder>{

    L4MatchAttributesFluent<?> fluent;
    Boolean validationEnabled;

    public L4MatchAttributesBuilder(){
            this(true);
    }
    public L4MatchAttributesBuilder(Boolean validationEnabled){
            this(new L4MatchAttributes(), validationEnabled);
    }
    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent){
            this(fluent, true);
    }
    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new L4MatchAttributes(), validationEnabled);
    }
    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent,L4MatchAttributes instance){
            this(fluent, instance, true);
    }
    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent,L4MatchAttributes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDestinationSubnets(instance.getDestinationSubnets()); 
            fluent.withGateways(instance.getGateways()); 
            fluent.withPort(instance.getPort()); 
            fluent.withSourceLabels(instance.getSourceLabels()); 
            fluent.withSourceNamespace(instance.getSourceNamespace()); 
            fluent.withSourceSubnet(instance.getSourceSubnet()); 
            this.validationEnabled = validationEnabled; 
    }
    public L4MatchAttributesBuilder(L4MatchAttributes instance){
            this(instance,true);
    }
    public L4MatchAttributesBuilder(L4MatchAttributes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDestinationSubnets(instance.getDestinationSubnets()); 
            this.withGateways(instance.getGateways()); 
            this.withPort(instance.getPort()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withSourceNamespace(instance.getSourceNamespace()); 
            this.withSourceSubnet(instance.getSourceSubnet()); 
            this.validationEnabled = validationEnabled; 
    }

    public L4MatchAttributes build(){
            L4MatchAttributes buildable = new L4MatchAttributes(fluent.getDestinationSubnets(),fluent.getGateways(),fluent.getPort(),fluent.getSourceLabels(),fluent.getSourceNamespace(),fluent.getSourceSubnet());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            L4MatchAttributesBuilder that = (L4MatchAttributesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
