
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "filterChain",
    "name",
    "portName",
    "portNumber"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ListenerMatch implements Serializable
{

    /**
     * 
     */
    @JsonProperty("filterChain")
    @JsonPropertyDescription("")
    private FilterChainMatch filterChain;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("portName")
    @JsonPropertyDescription("")
    private String portName;
    /**
     * 
     */
    @JsonProperty("portNumber")
    @JsonPropertyDescription("")
    private Integer portNumber;
    private final static long serialVersionUID = -3426973073118466190L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ListenerMatch() {
    }

    /**
     * 
     * @param name
     * @param portName
     * @param filterChain
     * @param portNumber
     */
    public ListenerMatch(FilterChainMatch filterChain, String name, String portName, Integer portNumber) {
        super();
        this.filterChain = filterChain;
        this.name = name;
        this.portName = portName;
        this.portNumber = portNumber;
    }

    /**
     * 
     */
    public FilterChainMatch getFilterChain() {
        return filterChain;
    }

    /**
     * 
     */
    public void setFilterChain(FilterChainMatch filterChain) {
        this.filterChain = filterChain;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public String getPortName() {
        return portName;
    }

    /**
     * 
     */
    public void setPortName(String portName) {
        this.portName = portName;
    }

    /**
     * 
     */
    public Integer getPortNumber() {
        return portNumber;
    }

    /**
     * 
     */
    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

}
