package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListenerMatchBuilder extends ListenerMatchFluentImpl<ListenerMatchBuilder> implements VisitableBuilder<ListenerMatch,ListenerMatchBuilder>{

    ListenerMatchFluent<?> fluent;
    Boolean validationEnabled;

    public ListenerMatchBuilder(){
            this(true);
    }
    public ListenerMatchBuilder(Boolean validationEnabled){
            this(new ListenerMatch(), validationEnabled);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent){
            this(fluent, true);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListenerMatch(), validationEnabled);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent,ListenerMatch instance){
            this(fluent, instance, true);
    }
    public ListenerMatchBuilder(ListenerMatchFluent<?> fluent,ListenerMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFilterChain(instance.getFilterChain()); 
            fluent.withName(instance.getName()); 
            fluent.withPortName(instance.getPortName()); 
            fluent.withPortNumber(instance.getPortNumber()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListenerMatchBuilder(ListenerMatch instance){
            this(instance,true);
    }
    public ListenerMatchBuilder(ListenerMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFilterChain(instance.getFilterChain()); 
            this.withName(instance.getName()); 
            this.withPortName(instance.getPortName()); 
            this.withPortNumber(instance.getPortNumber()); 
            this.validationEnabled = validationEnabled; 
    }

    public ListenerMatch build(){
            ListenerMatch buildable = new ListenerMatch(fluent.getFilterChain(),fluent.getName(),fluent.getPortName(),fluent.getPortNumber());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListenerMatchBuilder that = (ListenerMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
