
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.EnvoyConfigObjectMatch.ObjectTypes;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "listener"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ListenerObjectTypes implements Serializable, ObjectTypes
{

    /**
     * 
     */
    @JsonProperty("listener")
    @JsonPropertyDescription("")
    private ListenerMatch listener;
    private final static long serialVersionUID = 4156400288579274157L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ListenerObjectTypes() {
    }

    /**
     * 
     * @param listener
     */
    public ListenerObjectTypes(ListenerMatch listener) {
        super();
        this.listener = listener;
    }

    /**
     * 
     */
    public ListenerMatch getListener() {
        return listener;
    }

    /**
     * 
     */
    public void setListener(ListenerMatch listener) {
        this.listener = listener;
    }

}
