package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListenerObjectTypesBuilder extends ListenerObjectTypesFluentImpl<ListenerObjectTypesBuilder> implements VisitableBuilder<ListenerObjectTypes,ListenerObjectTypesBuilder>{

    ListenerObjectTypesFluent<?> fluent;
    Boolean validationEnabled;

    public ListenerObjectTypesBuilder(){
            this(true);
    }
    public ListenerObjectTypesBuilder(Boolean validationEnabled){
            this(new ListenerObjectTypes(), validationEnabled);
    }
    public ListenerObjectTypesBuilder(ListenerObjectTypesFluent<?> fluent){
            this(fluent, true);
    }
    public ListenerObjectTypesBuilder(ListenerObjectTypesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListenerObjectTypes(), validationEnabled);
    }
    public ListenerObjectTypesBuilder(ListenerObjectTypesFluent<?> fluent,ListenerObjectTypes instance){
            this(fluent, instance, true);
    }
    public ListenerObjectTypesBuilder(ListenerObjectTypesFluent<?> fluent,ListenerObjectTypes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withListener(instance.getListener()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListenerObjectTypesBuilder(ListenerObjectTypes instance){
            this(instance,true);
    }
    public ListenerObjectTypesBuilder(ListenerObjectTypes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withListener(instance.getListener()); 
            this.validationEnabled = validationEnabled; 
    }

    public ListenerObjectTypes build(){
            ListenerObjectTypes buildable = new ListenerObjectTypes(fluent.getListener());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListenerObjectTypesBuilder that = (ListenerObjectTypesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
