package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerSettingsBuilder extends LoadBalancerSettingsFluentImpl<LoadBalancerSettingsBuilder> implements VisitableBuilder<LoadBalancerSettings,LoadBalancerSettingsBuilder>{

    LoadBalancerSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerSettingsBuilder(){
            this(true);
    }
    public LoadBalancerSettingsBuilder(Boolean validationEnabled){
            this(new LoadBalancerSettings(), validationEnabled);
    }
    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LoadBalancerSettings(), validationEnabled);
    }
    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent,LoadBalancerSettings instance){
            this(fluent, instance, true);
    }
    public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent,LoadBalancerSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLbPolicy(instance.getLbPolicy()); 
            fluent.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.validationEnabled = validationEnabled; 
    }
    public LoadBalancerSettingsBuilder(LoadBalancerSettings instance){
            this(instance,true);
    }
    public LoadBalancerSettingsBuilder(LoadBalancerSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLbPolicy(instance.getLbPolicy()); 
            this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerSettings build(){
            LoadBalancerSettings buildable = new LoadBalancerSettings(fluent.getLbPolicy(),fluent.getLocalityLbSetting());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LoadBalancerSettingsBuilder that = (LoadBalancerSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
