package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Object;

public class LoadBalancerSettingsFluentImpl<A extends LoadBalancerSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LoadBalancerSettingsFluent<A>{

    private VisitableBuilder<? extends LoadBalancerSettings.LbPolicy,?> lbPolicy;
    private LocalityLoadBalancerSettingBuilder localityLbSetting;

    public LoadBalancerSettingsFluentImpl(){
    }
    public LoadBalancerSettingsFluentImpl(LoadBalancerSettings instance){
            this.withLbPolicy(instance.getLbPolicy()); 
            this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
    }

    
/**
 * This method has been deprecated, please use method buildLbPolicy instead.
 * @return The buildable object.
 */
@Deprecated public LoadBalancerSettings.LbPolicy getLbPolicy(){
            return this.lbPolicy!=null?this.lbPolicy.build():null;
    }

    public LoadBalancerSettings.LbPolicy buildLbPolicy(){
            return this.lbPolicy!=null?this.lbPolicy.build():null;
    }

    public A withLbPolicy(LoadBalancerSettings.LbPolicy lbPolicy){
            if (lbPolicy instanceof SimpleLbPolicy){ this.lbPolicy= new SimpleLbPolicyBuilder((SimpleLbPolicy)lbPolicy); _visitables.get("lbPolicy").add(this.lbPolicy);}
            if (lbPolicy instanceof ConsistentHashLbPolicy){ this.lbPolicy= new ConsistentHashLbPolicyBuilder((ConsistentHashLbPolicy)lbPolicy); _visitables.get("lbPolicy").add(this.lbPolicy);}
            return (A) this;
    }

    public Boolean hasLbPolicy(){
            return this.lbPolicy != null;
    }

    public A withSimpleLbPolicy(SimpleLbPolicy simpleLbPolicy){
            _visitables.get("lbPolicy").remove(this.lbPolicy);
            if (simpleLbPolicy!=null){ this.lbPolicy= new SimpleLbPolicyBuilder(simpleLbPolicy); _visitables.get("lbPolicy").add(this.lbPolicy);} return (A) this;
    }

    public LoadBalancerSettingsFluent.SimpleLbPolicyNested<A> withNewSimpleLbPolicy(){
            return new SimpleLbPolicyNestedImpl();
    }

    public LoadBalancerSettingsFluent.SimpleLbPolicyNested<A> withNewSimpleLbPolicyLike(SimpleLbPolicy item){
            return new SimpleLbPolicyNestedImpl(item);
    }

    public A withConsistentHashLbPolicy(ConsistentHashLbPolicy consistentHashLbPolicy){
            _visitables.get("lbPolicy").remove(this.lbPolicy);
            if (consistentHashLbPolicy!=null){ this.lbPolicy= new ConsistentHashLbPolicyBuilder(consistentHashLbPolicy); _visitables.get("lbPolicy").add(this.lbPolicy);} return (A) this;
    }

    public LoadBalancerSettingsFluent.ConsistentHashLbPolicyNested<A> withNewConsistentHashLbPolicy(){
            return new ConsistentHashLbPolicyNestedImpl();
    }

    public LoadBalancerSettingsFluent.ConsistentHashLbPolicyNested<A> withNewConsistentHashLbPolicyLike(ConsistentHashLbPolicy item){
            return new ConsistentHashLbPolicyNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildLocalityLbSetting instead.
 * @return The buildable object.
 */
@Deprecated public LocalityLoadBalancerSetting getLocalityLbSetting(){
            return this.localityLbSetting!=null?this.localityLbSetting.build():null;
    }

    public LocalityLoadBalancerSetting buildLocalityLbSetting(){
            return this.localityLbSetting!=null?this.localityLbSetting.build():null;
    }

    public A withLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting){
            _visitables.get("localityLbSetting").remove(this.localityLbSetting);
            if (localityLbSetting!=null){ this.localityLbSetting= new LocalityLoadBalancerSettingBuilder(localityLbSetting); _visitables.get("localityLbSetting").add(this.localityLbSetting);} return (A) this;
    }

    public Boolean hasLocalityLbSetting(){
            return this.localityLbSetting != null;
    }

    public LoadBalancerSettingsFluent.LocalityLbSettingNested<A> withNewLocalityLbSetting(){
            return new LocalityLbSettingNestedImpl();
    }

    public LoadBalancerSettingsFluent.LocalityLbSettingNested<A> withNewLocalityLbSettingLike(LocalityLoadBalancerSetting item){
            return new LocalityLbSettingNestedImpl(item);
    }

    public LoadBalancerSettingsFluent.LocalityLbSettingNested<A> editLocalityLbSetting(){
            return withNewLocalityLbSettingLike(getLocalityLbSetting());
    }

    public LoadBalancerSettingsFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSetting(){
            return withNewLocalityLbSettingLike(getLocalityLbSetting() != null ? getLocalityLbSetting(): new LocalityLoadBalancerSettingBuilder().build());
    }

    public LoadBalancerSettingsFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSettingLike(LocalityLoadBalancerSetting item){
            return withNewLocalityLbSettingLike(getLocalityLbSetting() != null ? getLocalityLbSetting(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LoadBalancerSettingsFluentImpl that = (LoadBalancerSettingsFluentImpl) o;
            if (lbPolicy != null ? !lbPolicy.equals(that.lbPolicy) :that.lbPolicy != null) return false;
            if (localityLbSetting != null ? !localityLbSetting.equals(that.localityLbSetting) :that.localityLbSetting != null) return false;
            return true;
    }


    public class SimpleLbPolicyNestedImpl<N> extends SimpleLbPolicyFluentImpl<LoadBalancerSettingsFluent.SimpleLbPolicyNested<N>> implements LoadBalancerSettingsFluent.SimpleLbPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SimpleLbPolicyBuilder builder;
    
            SimpleLbPolicyNestedImpl(SimpleLbPolicy item){
                    this.builder = new SimpleLbPolicyBuilder(this, item);
            }
            SimpleLbPolicyNestedImpl(){
                    this.builder = new SimpleLbPolicyBuilder(this);
            }
    
    public N and(){
            return (N) LoadBalancerSettingsFluentImpl.this.withLbPolicy(builder.build());
    }
    public N endSimpleLbPolicy(){
            return and();
    }

}
    public class ConsistentHashLbPolicyNestedImpl<N> extends ConsistentHashLbPolicyFluentImpl<LoadBalancerSettingsFluent.ConsistentHashLbPolicyNested<N>> implements LoadBalancerSettingsFluent.ConsistentHashLbPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConsistentHashLbPolicyBuilder builder;
    
            ConsistentHashLbPolicyNestedImpl(ConsistentHashLbPolicy item){
                    this.builder = new ConsistentHashLbPolicyBuilder(this, item);
            }
            ConsistentHashLbPolicyNestedImpl(){
                    this.builder = new ConsistentHashLbPolicyBuilder(this);
            }
    
    public N and(){
            return (N) LoadBalancerSettingsFluentImpl.this.withLbPolicy(builder.build());
    }
    public N endConsistentHashLbPolicy(){
            return and();
    }

}
    public class LocalityLbSettingNestedImpl<N> extends LocalityLoadBalancerSettingFluentImpl<LoadBalancerSettingsFluent.LocalityLbSettingNested<N>> implements LoadBalancerSettingsFluent.LocalityLbSettingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalityLoadBalancerSettingBuilder builder;
    
            LocalityLbSettingNestedImpl(LocalityLoadBalancerSetting item){
                    this.builder = new LocalityLoadBalancerSettingBuilder(this, item);
            }
            LocalityLbSettingNestedImpl(){
                    this.builder = new LocalityLoadBalancerSettingBuilder(this);
            }
    
    public N and(){
            return (N) LoadBalancerSettingsFluentImpl.this.withLocalityLbSetting(builder.build());
    }
    public N endLocalityLbSetting(){
            return and();
    }

}


}
