package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OutlierDetectionBuilder extends OutlierDetectionFluentImpl<OutlierDetectionBuilder> implements VisitableBuilder<OutlierDetection,OutlierDetectionBuilder>{

    OutlierDetectionFluent<?> fluent;
    Boolean validationEnabled;

    public OutlierDetectionBuilder(){
            this(true);
    }
    public OutlierDetectionBuilder(Boolean validationEnabled){
            this(new OutlierDetection(), validationEnabled);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent){
            this(fluent, true);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OutlierDetection(), validationEnabled);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance){
            this(fluent, instance, true);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBaseEjectionTime(instance.getBaseEjectionTime()); 
            fluent.withConsecutive5xxErrors(instance.getConsecutive5xxErrors()); 
            fluent.withConsecutiveErrors(instance.getConsecutiveErrors()); 
            fluent.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors()); 
            fluent.withInterval(instance.getInterval()); 
            fluent.withMaxEjectionPercent(instance.getMaxEjectionPercent()); 
            fluent.withMinHealthPercent(instance.getMinHealthPercent()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutlierDetectionBuilder(OutlierDetection instance){
            this(instance,true);
    }
    public OutlierDetectionBuilder(OutlierDetection instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBaseEjectionTime(instance.getBaseEjectionTime()); 
            this.withConsecutive5xxErrors(instance.getConsecutive5xxErrors()); 
            this.withConsecutiveErrors(instance.getConsecutiveErrors()); 
            this.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors()); 
            this.withInterval(instance.getInterval()); 
            this.withMaxEjectionPercent(instance.getMaxEjectionPercent()); 
            this.withMinHealthPercent(instance.getMinHealthPercent()); 
            this.validationEnabled = validationEnabled; 
    }

    public OutlierDetection build(){
            OutlierDetection buildable = new OutlierDetection(fluent.getBaseEjectionTime(),fluent.getConsecutive5xxErrors(),fluent.getConsecutiveErrors(),fluent.getConsecutiveGatewayErrors(),fluent.getInterval(),fluent.getMaxEjectionPercent(),fluent.getMinHealthPercent());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OutlierDetectionBuilder that = (OutlierDetectionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
