package me.snowdrop.istio.api.networking.v1alpha3;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class OutlierDetectionFluentImpl<A extends OutlierDetectionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OutlierDetectionFluent<A>{

    private DurationBuilder baseEjectionTime;
    private Integer consecutive5xxErrors;
    private Integer consecutiveErrors;
    private Integer consecutiveGatewayErrors;
    private DurationBuilder interval;
    private Integer maxEjectionPercent;
    private Integer minHealthPercent;

    public OutlierDetectionFluentImpl(){
    }
    public OutlierDetectionFluentImpl(OutlierDetection instance){
            this.withBaseEjectionTime(instance.getBaseEjectionTime()); 
            this.withConsecutive5xxErrors(instance.getConsecutive5xxErrors()); 
            this.withConsecutiveErrors(instance.getConsecutiveErrors()); 
            this.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors()); 
            this.withInterval(instance.getInterval()); 
            this.withMaxEjectionPercent(instance.getMaxEjectionPercent()); 
            this.withMinHealthPercent(instance.getMinHealthPercent()); 
    }

    
/**
 * This method has been deprecated, please use method buildBaseEjectionTime instead.
 * @return The buildable object.
 */
@Deprecated public Duration getBaseEjectionTime(){
            return this.baseEjectionTime!=null?this.baseEjectionTime.build():null;
    }

    public Duration buildBaseEjectionTime(){
            return this.baseEjectionTime!=null?this.baseEjectionTime.build():null;
    }

    public A withBaseEjectionTime(Duration baseEjectionTime){
            _visitables.get("baseEjectionTime").remove(this.baseEjectionTime);
            if (baseEjectionTime!=null){ this.baseEjectionTime= new DurationBuilder(baseEjectionTime); _visitables.get("baseEjectionTime").add(this.baseEjectionTime);} return (A) this;
    }

    public Boolean hasBaseEjectionTime(){
            return this.baseEjectionTime != null;
    }

    public A withNewBaseEjectionTime(Integer nanos,Long seconds){
            return (A)withBaseEjectionTime(new Duration(nanos, seconds));
    }

    public OutlierDetectionFluent.BaseEjectionTimeNested<A> withNewBaseEjectionTime(){
            return new BaseEjectionTimeNestedImpl();
    }

    public OutlierDetectionFluent.BaseEjectionTimeNested<A> withNewBaseEjectionTimeLike(Duration item){
            return new BaseEjectionTimeNestedImpl(item);
    }

    public OutlierDetectionFluent.BaseEjectionTimeNested<A> editBaseEjectionTime(){
            return withNewBaseEjectionTimeLike(getBaseEjectionTime());
    }

    public OutlierDetectionFluent.BaseEjectionTimeNested<A> editOrNewBaseEjectionTime(){
            return withNewBaseEjectionTimeLike(getBaseEjectionTime() != null ? getBaseEjectionTime(): new DurationBuilder().build());
    }

    public OutlierDetectionFluent.BaseEjectionTimeNested<A> editOrNewBaseEjectionTimeLike(Duration item){
            return withNewBaseEjectionTimeLike(getBaseEjectionTime() != null ? getBaseEjectionTime(): item);
    }

    public Integer getConsecutive5xxErrors(){
            return this.consecutive5xxErrors;
    }

    public A withConsecutive5xxErrors(Integer consecutive5xxErrors){
            this.consecutive5xxErrors=consecutive5xxErrors; return (A) this;
    }

    public Boolean hasConsecutive5xxErrors(){
            return this.consecutive5xxErrors != null;
    }

    public Integer getConsecutiveErrors(){
            return this.consecutiveErrors;
    }

    public A withConsecutiveErrors(Integer consecutiveErrors){
            this.consecutiveErrors=consecutiveErrors; return (A) this;
    }

    public Boolean hasConsecutiveErrors(){
            return this.consecutiveErrors != null;
    }

    public Integer getConsecutiveGatewayErrors(){
            return this.consecutiveGatewayErrors;
    }

    public A withConsecutiveGatewayErrors(Integer consecutiveGatewayErrors){
            this.consecutiveGatewayErrors=consecutiveGatewayErrors; return (A) this;
    }

    public Boolean hasConsecutiveGatewayErrors(){
            return this.consecutiveGatewayErrors != null;
    }

    
/**
 * This method has been deprecated, please use method buildInterval instead.
 * @return The buildable object.
 */
@Deprecated public Duration getInterval(){
            return this.interval!=null?this.interval.build():null;
    }

    public Duration buildInterval(){
            return this.interval!=null?this.interval.build():null;
    }

    public A withInterval(Duration interval){
            _visitables.get("interval").remove(this.interval);
            if (interval!=null){ this.interval= new DurationBuilder(interval); _visitables.get("interval").add(this.interval);} return (A) this;
    }

    public Boolean hasInterval(){
            return this.interval != null;
    }

    public A withNewInterval(Integer nanos,Long seconds){
            return (A)withInterval(new Duration(nanos, seconds));
    }

    public OutlierDetectionFluent.IntervalNested<A> withNewInterval(){
            return new IntervalNestedImpl();
    }

    public OutlierDetectionFluent.IntervalNested<A> withNewIntervalLike(Duration item){
            return new IntervalNestedImpl(item);
    }

    public OutlierDetectionFluent.IntervalNested<A> editInterval(){
            return withNewIntervalLike(getInterval());
    }

    public OutlierDetectionFluent.IntervalNested<A> editOrNewInterval(){
            return withNewIntervalLike(getInterval() != null ? getInterval(): new DurationBuilder().build());
    }

    public OutlierDetectionFluent.IntervalNested<A> editOrNewIntervalLike(Duration item){
            return withNewIntervalLike(getInterval() != null ? getInterval(): item);
    }

    public Integer getMaxEjectionPercent(){
            return this.maxEjectionPercent;
    }

    public A withMaxEjectionPercent(Integer maxEjectionPercent){
            this.maxEjectionPercent=maxEjectionPercent; return (A) this;
    }

    public Boolean hasMaxEjectionPercent(){
            return this.maxEjectionPercent != null;
    }

    public Integer getMinHealthPercent(){
            return this.minHealthPercent;
    }

    public A withMinHealthPercent(Integer minHealthPercent){
            this.minHealthPercent=minHealthPercent; return (A) this;
    }

    public Boolean hasMinHealthPercent(){
            return this.minHealthPercent != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            OutlierDetectionFluentImpl that = (OutlierDetectionFluentImpl) o;
            if (baseEjectionTime != null ? !baseEjectionTime.equals(that.baseEjectionTime) :that.baseEjectionTime != null) return false;
            if (consecutive5xxErrors != null ? !consecutive5xxErrors.equals(that.consecutive5xxErrors) :that.consecutive5xxErrors != null) return false;
            if (consecutiveErrors != null ? !consecutiveErrors.equals(that.consecutiveErrors) :that.consecutiveErrors != null) return false;
            if (consecutiveGatewayErrors != null ? !consecutiveGatewayErrors.equals(that.consecutiveGatewayErrors) :that.consecutiveGatewayErrors != null) return false;
            if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
            if (maxEjectionPercent != null ? !maxEjectionPercent.equals(that.maxEjectionPercent) :that.maxEjectionPercent != null) return false;
            if (minHealthPercent != null ? !minHealthPercent.equals(that.minHealthPercent) :that.minHealthPercent != null) return false;
            return true;
    }


    public class BaseEjectionTimeNestedImpl<N> extends DurationFluentImpl<OutlierDetectionFluent.BaseEjectionTimeNested<N>> implements OutlierDetectionFluent.BaseEjectionTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            BaseEjectionTimeNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            BaseEjectionTimeNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) OutlierDetectionFluentImpl.this.withBaseEjectionTime(builder.build());
    }
    public N endBaseEjectionTime(){
            return and();
    }

}
    public class IntervalNestedImpl<N> extends DurationFluentImpl<OutlierDetectionFluent.IntervalNested<N>> implements OutlierDetectionFluent.IntervalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            IntervalNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            IntervalNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) OutlierDetectionFluentImpl.this.withInterval(builder.build());
    }
    public N endInterval(){
            return and();
    }

}


}
