package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class PatchFluentImpl<A extends PatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PatchFluent<A>{

    private me.snowdrop.istio.api.networking.v1alpha3.Operation operation;
    private Map<String,Object> value;

    public PatchFluentImpl(){
    }
    public PatchFluentImpl(Patch instance){
            this.withOperation(instance.getOperation()); 
            this.withValue(instance.getValue()); 
    }

    public me.snowdrop.istio.api.networking.v1alpha3.Operation getOperation(){
            return this.operation;
    }

    public A withOperation(me.snowdrop.istio.api.networking.v1alpha3.Operation operation){
            this.operation=operation; return (A) this;
    }

    public Boolean hasOperation(){
            return this.operation != null;
    }

    public A addToValue(String key,Object value){
            if(this.value == null && key != null && value != null) { this.value = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.value.put(key, value);} return (A)this;
    }

    public A addToValue(Map<String,Object> map){
            if(this.value == null && map != null) { this.value = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.value.putAll(map);} return (A)this;
    }

    public A removeFromValue(String key){
            if(this.value == null) { return (A) this; }
            if(key != null && this.value != null) {this.value.remove(key);} return (A)this;
    }

    public A removeFromValue(Map<String,Object> map){
            if(this.value == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.value != null){this.value.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getValue(){
            return this.value;
    }

    public A withValue(Map<String,Object> value){
            if (value == null) { this.value =  null;} else {this.value = new LinkedHashMap<String,Object>(value);} return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PatchFluentImpl that = (PatchFluentImpl) o;
            if (operation != null ? !operation.equals(that.operation) :that.operation != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
