
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Percent implements Serializable
{

    /**
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    private Double value;
    private final static long serialVersionUID = -2048286437442258018L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Percent() {
    }

    /**
     * 
     * @param value
     */
    public Percent(Double value) {
        super();
        this.value = value;
    }

    /**
     * 
     */
    public Double getValue() {
        return value;
    }

    /**
     * 
     */
    public void setValue(Double value) {
        this.value = value;
    }

}
