package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PercentBuilder extends PercentFluentImpl<PercentBuilder> implements VisitableBuilder<Percent,PercentBuilder>{

    PercentFluent<?> fluent;
    Boolean validationEnabled;

    public PercentBuilder(){
            this(true);
    }
    public PercentBuilder(Boolean validationEnabled){
            this(new Percent(), validationEnabled);
    }
    public PercentBuilder(PercentFluent<?> fluent){
            this(fluent, true);
    }
    public PercentBuilder(PercentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Percent(), validationEnabled);
    }
    public PercentBuilder(PercentFluent<?> fluent,Percent instance){
            this(fluent, instance, true);
    }
    public PercentBuilder(PercentFluent<?> fluent,Percent instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public PercentBuilder(Percent instance){
            this(instance,true);
    }
    public PercentBuilder(Percent instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public Percent build(){
            Percent buildable = new Percent(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PercentBuilder that = (PercentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
