
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "number"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class PortSelector implements Serializable
{

    /**
     * 
     */
    @JsonProperty("number")
    @JsonPropertyDescription("")
    private Integer number;
    private final static long serialVersionUID = 6436313135930388386L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PortSelector() {
    }

    /**
     * 
     * @param number
     */
    public PortSelector(Integer number) {
        super();
        this.number = number;
    }

    /**
     * 
     */
    public Integer getNumber() {
        return number;
    }

    /**
     * 
     */
    public void setNumber(Integer number) {
        this.number = number;
    }

}
