package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PortSelectorBuilder extends PortSelectorFluentImpl<PortSelectorBuilder> implements VisitableBuilder<PortSelector,PortSelectorBuilder>{

    PortSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public PortSelectorBuilder(){
            this(true);
    }
    public PortSelectorBuilder(Boolean validationEnabled){
            this(new PortSelector(), validationEnabled);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PortSelector(), validationEnabled);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent,PortSelector instance){
            this(fluent, instance, true);
    }
    public PortSelectorBuilder(PortSelectorFluent<?> fluent,PortSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNumber(instance.getNumber()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortSelectorBuilder(PortSelector instance){
            this(instance,true);
    }
    public PortSelectorBuilder(PortSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNumber(instance.getNumber()); 
            this.validationEnabled = validationEnabled; 
    }

    public PortSelector build(){
            PortSelector buildable = new PortSelector(fluent.getNumber());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortSelectorBuilder that = (PortSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
