
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectionPool",
    "loadBalancer",
    "outlierDetection",
    "port",
    "tls"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class PortTrafficPolicy implements Serializable
{

    /**
     * 
     */
    @JsonProperty("connectionPool")
    @JsonPropertyDescription("")
    private ConnectionPoolSettings connectionPool;
    /**
     * 
     */
    @JsonProperty("loadBalancer")
    @JsonPropertyDescription("")
    private LoadBalancerSettings loadBalancer;
    /**
     * 
     */
    @JsonProperty("outlierDetection")
    @JsonPropertyDescription("")
    private OutlierDetection outlierDetection;
    /**
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private PortSelector port;
    /**
     * 
     */
    @JsonProperty("tls")
    @JsonPropertyDescription("")
    private ClientTLSSettings tls;
    private final static long serialVersionUID = 4073650435004085510L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PortTrafficPolicy() {
    }

    /**
     * 
     * @param port
     * @param loadBalancer
     * @param connectionPool
     * @param tls
     * @param outlierDetection
     */
    public PortTrafficPolicy(ConnectionPoolSettings connectionPool, LoadBalancerSettings loadBalancer, OutlierDetection outlierDetection, PortSelector port, ClientTLSSettings tls) {
        super();
        this.connectionPool = connectionPool;
        this.loadBalancer = loadBalancer;
        this.outlierDetection = outlierDetection;
        this.port = port;
        this.tls = tls;
    }

    /**
     * 
     */
    public ConnectionPoolSettings getConnectionPool() {
        return connectionPool;
    }

    /**
     * 
     */
    public void setConnectionPool(ConnectionPoolSettings connectionPool) {
        this.connectionPool = connectionPool;
    }

    /**
     * 
     */
    public LoadBalancerSettings getLoadBalancer() {
        return loadBalancer;
    }

    /**
     * 
     */
    public void setLoadBalancer(LoadBalancerSettings loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    /**
     * 
     */
    public OutlierDetection getOutlierDetection() {
        return outlierDetection;
    }

    /**
     * 
     */
    public void setOutlierDetection(OutlierDetection outlierDetection) {
        this.outlierDetection = outlierDetection;
    }

    /**
     * 
     */
    public PortSelector getPort() {
        return port;
    }

    /**
     * 
     */
    public void setPort(PortSelector port) {
        this.port = port;
    }

    /**
     * 
     */
    public ClientTLSSettings getTls() {
        return tls;
    }

    /**
     * 
     */
    public void setTls(ClientTLSSettings tls) {
        this.tls = tls;
    }

}
