package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class PortTrafficPolicyFluentImpl<A extends PortTrafficPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PortTrafficPolicyFluent<A>{

    private ConnectionPoolSettingsBuilder connectionPool;
    private LoadBalancerSettingsBuilder loadBalancer;
    private OutlierDetectionBuilder outlierDetection;
    private PortSelectorBuilder port;
    private ClientTLSSettingsBuilder tls;

    public PortTrafficPolicyFluentImpl(){
    }
    public PortTrafficPolicyFluentImpl(PortTrafficPolicy instance){
            this.withConnectionPool(instance.getConnectionPool()); 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.withOutlierDetection(instance.getOutlierDetection()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
    }

    
/**
 * This method has been deprecated, please use method buildConnectionPool instead.
 * @return The buildable object.
 */
@Deprecated public ConnectionPoolSettings getConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public ConnectionPoolSettings buildConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public A withConnectionPool(ConnectionPoolSettings connectionPool){
            _visitables.get("connectionPool").remove(this.connectionPool);
            if (connectionPool!=null){ this.connectionPool= new ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} return (A) this;
    }

    public Boolean hasConnectionPool(){
            return this.connectionPool != null;
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPool(){
            return new ConnectionPoolNestedImpl();
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item){
            return new ConnectionPoolNestedImpl(item);
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> editConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool());
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): new ConnectionPoolSettingsBuilder().build());
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public LoadBalancerSettings getLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public LoadBalancerSettings buildLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(LoadBalancerSettings loadBalancer){
            _visitables.get("loadBalancer").remove(this.loadBalancer);
            if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} return (A) this;
    }

    public Boolean hasLoadBalancer(){
            return this.loadBalancer != null;
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancer(){
            return new LoadBalancerNestedImpl();
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item){
            return new LoadBalancerNestedImpl(item);
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> editLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer());
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new LoadBalancerSettingsBuilder().build());
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOutlierDetection instead.
 * @return The buildable object.
 */
@Deprecated public OutlierDetection getOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public OutlierDetection buildOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public A withOutlierDetection(OutlierDetection outlierDetection){
            _visitables.get("outlierDetection").remove(this.outlierDetection);
            if (outlierDetection!=null){ this.outlierDetection= new OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} return (A) this;
    }

    public Boolean hasOutlierDetection(){
            return this.outlierDetection != null;
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetection(){
            return new OutlierDetectionNestedImpl();
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item){
            return new OutlierDetectionNestedImpl(item);
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> editOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection());
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): new OutlierDetectionBuilder().build());
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public PortSelector getPort(){
            return this.port!=null?this.port.build():null;
    }

    public PortSelector buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(PortSelector port){
            _visitables.get("port").remove(this.port);
            if (port!=null){ this.port= new PortSelectorBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(Integer number){
            return (A)withPort(new PortSelector(number));
    }

    public PortTrafficPolicyFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public PortTrafficPolicyFluent.PortNested<A> withNewPortLike(PortSelector item){
            return new PortNestedImpl(item);
    }

    public PortTrafficPolicyFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public PortTrafficPolicyFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new PortSelectorBuilder().build());
    }

    public PortTrafficPolicyFluent.PortNested<A> editOrNewPortLike(PortSelector item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public ClientTLSSettings getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public ClientTLSSettings buildTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(ClientTLSSettings tls){
            _visitables.get("tls").remove(this.tls);
            if (tls!=null){ this.tls= new ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls(){
            return this.tls != null;
    }

    public PortTrafficPolicyFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public PortTrafficPolicyFluent.TlsNested<A> withNewTlsLike(ClientTLSSettings item){
            return new TlsNestedImpl(item);
    }

    public PortTrafficPolicyFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public PortTrafficPolicyFluent.TlsNested<A> editOrNewTls(){
            return withNewTlsLike(getTls() != null ? getTls(): new ClientTLSSettingsBuilder().build());
    }

    public PortTrafficPolicyFluent.TlsNested<A> editOrNewTlsLike(ClientTLSSettings item){
            return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PortTrafficPolicyFluentImpl that = (PortTrafficPolicyFluentImpl) o;
            if (connectionPool != null ? !connectionPool.equals(that.connectionPool) :that.connectionPool != null) return false;
            if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
            if (outlierDetection != null ? !outlierDetection.equals(that.outlierDetection) :that.outlierDetection != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class ConnectionPoolNestedImpl<N> extends ConnectionPoolSettingsFluentImpl<PortTrafficPolicyFluent.ConnectionPoolNested<N>> implements PortTrafficPolicyFluent.ConnectionPoolNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConnectionPoolSettingsBuilder builder;
    
            ConnectionPoolNestedImpl(ConnectionPoolSettings item){
                    this.builder = new ConnectionPoolSettingsBuilder(this, item);
            }
            ConnectionPoolNestedImpl(){
                    this.builder = new ConnectionPoolSettingsBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool(){
            return and();
    }

}
    public class LoadBalancerNestedImpl<N> extends LoadBalancerSettingsFluentImpl<PortTrafficPolicyFluent.LoadBalancerNested<N>> implements PortTrafficPolicyFluent.LoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LoadBalancerSettingsBuilder builder;
    
            LoadBalancerNestedImpl(LoadBalancerSettings item){
                    this.builder = new LoadBalancerSettingsBuilder(this, item);
            }
            LoadBalancerNestedImpl(){
                    this.builder = new LoadBalancerSettingsBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer(){
            return and();
    }

}
    public class OutlierDetectionNestedImpl<N> extends OutlierDetectionFluentImpl<PortTrafficPolicyFluent.OutlierDetectionNested<N>> implements PortTrafficPolicyFluent.OutlierDetectionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OutlierDetectionBuilder builder;
    
            OutlierDetectionNestedImpl(OutlierDetection item){
                    this.builder = new OutlierDetectionBuilder(this, item);
            }
            OutlierDetectionNestedImpl(){
                    this.builder = new OutlierDetectionBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection(){
            return and();
    }

}
    public class PortNestedImpl<N> extends PortSelectorFluentImpl<PortTrafficPolicyFluent.PortNested<N>> implements PortTrafficPolicyFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PortSelectorBuilder builder;
    
            PortNestedImpl(PortSelector item){
                    this.builder = new PortSelectorBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new PortSelectorBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends ClientTLSSettingsFluentImpl<PortTrafficPolicyFluent.TlsNested<N>> implements PortTrafficPolicyFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClientTLSSettingsBuilder builder;
    
            TlsNestedImpl(ClientTLSSettings item){
                    this.builder = new ClientTLSSettingsBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.builder = new ClientTLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withTls(builder.build());
    }
    public N endTls(){
            return and();
    }

}


}
