package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrefixMatchTypeBuilder extends PrefixMatchTypeFluentImpl<PrefixMatchTypeBuilder> implements VisitableBuilder<PrefixMatchType,PrefixMatchTypeBuilder>{

    PrefixMatchTypeFluent<?> fluent;
    Boolean validationEnabled;

    public PrefixMatchTypeBuilder(){
            this(true);
    }
    public PrefixMatchTypeBuilder(Boolean validationEnabled){
            this(new PrefixMatchType(), validationEnabled);
    }
    public PrefixMatchTypeBuilder(PrefixMatchTypeFluent<?> fluent){
            this(fluent, true);
    }
    public PrefixMatchTypeBuilder(PrefixMatchTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PrefixMatchType(), validationEnabled);
    }
    public PrefixMatchTypeBuilder(PrefixMatchTypeFluent<?> fluent,PrefixMatchType instance){
            this(fluent, instance, true);
    }
    public PrefixMatchTypeBuilder(PrefixMatchTypeFluent<?> fluent,PrefixMatchType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPrefix(instance.getPrefix()); 
            this.validationEnabled = validationEnabled; 
    }
    public PrefixMatchTypeBuilder(PrefixMatchType instance){
            this(instance,true);
    }
    public PrefixMatchTypeBuilder(PrefixMatchType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPrefix(instance.getPrefix()); 
            this.validationEnabled = validationEnabled; 
    }

    public PrefixMatchType build(){
            PrefixMatchType buildable = new PrefixMatchType(fluent.getPrefix());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PrefixMatchTypeBuilder that = (PrefixMatchTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
