
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "proxyVersion"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ProxyMatch implements Serializable
{

    /**
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("")
    private Map<String, String> metadata;
    /**
     * 
     */
    @JsonProperty("proxyVersion")
    @JsonPropertyDescription("")
    private java.lang.String proxyVersion;
    private final static long serialVersionUID = 5067521748145721350L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProxyMatch() {
    }

    /**
     * 
     * @param metadata
     * @param proxyVersion
     */
    public ProxyMatch(Map<String, String> metadata, java.lang.String proxyVersion) {
        super();
        this.metadata = metadata;
        this.proxyVersion = proxyVersion;
    }

    /**
     * 
     */
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * 
     */
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    /**
     * 
     */
    public java.lang.String getProxyVersion() {
        return proxyVersion;
    }

    /**
     * 
     */
    public void setProxyVersion(java.lang.String proxyVersion) {
        this.proxyVersion = proxyVersion;
    }

}
