package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyMatchBuilder extends ProxyMatchFluentImpl<ProxyMatchBuilder> implements VisitableBuilder<ProxyMatch,ProxyMatchBuilder>{

    ProxyMatchFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyMatchBuilder(){
            this(true);
    }
    public ProxyMatchBuilder(Boolean validationEnabled){
            this(new ProxyMatch(), validationEnabled);
    }
    public ProxyMatchBuilder(ProxyMatchFluent<?> fluent){
            this(fluent, true);
    }
    public ProxyMatchBuilder(ProxyMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ProxyMatch(), validationEnabled);
    }
    public ProxyMatchBuilder(ProxyMatchFluent<?> fluent,ProxyMatch instance){
            this(fluent, instance, true);
    }
    public ProxyMatchBuilder(ProxyMatchFluent<?> fluent,ProxyMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withProxyVersion(instance.getProxyVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public ProxyMatchBuilder(ProxyMatch instance){
            this(instance,true);
    }
    public ProxyMatchBuilder(ProxyMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata()); 
            this.withProxyVersion(instance.getProxyVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public ProxyMatch build(){
            ProxyMatch buildable = new ProxyMatch(fluent.getMetadata(),fluent.getProxyVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ProxyMatchBuilder that = (ProxyMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
