package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class ProxyMatchFluentImpl<A extends ProxyMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProxyMatchFluent<A>{

    private Map<String,String> metadata;
    private String proxyVersion;

    public ProxyMatchFluentImpl(){
    }
    public ProxyMatchFluentImpl(ProxyMatch instance){
            this.withMetadata(instance.getMetadata()); 
            this.withProxyVersion(instance.getProxyVersion()); 
    }

    public A addToMetadata(String key,String value){
            if(this.metadata == null && key != null && value != null) { this.metadata = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
    }

    public A addToMetadata(Map<String,String> map){
            if(this.metadata == null && map != null) { this.metadata = new LinkedHashMap<String,String>(); }
            if(map != null) { this.metadata.putAll(map);} return (A)this;
    }

    public A removeFromMetadata(String key){
            if(this.metadata == null) { return (A) this; }
            if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
    }

    public A removeFromMetadata(Map<String,String> map){
            if(this.metadata == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
    }

    public Map<String,String> getMetadata(){
            return this.metadata;
    }

    public A withMetadata(Map<String,String> metadata){
            if (metadata == null) { this.metadata =  null;} else {this.metadata = new LinkedHashMap<String,String>(metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public String getProxyVersion(){
            return this.proxyVersion;
    }

    public A withProxyVersion(String proxyVersion){
            this.proxyVersion=proxyVersion; return (A) this;
    }

    public Boolean hasProxyVersion(){
            return this.proxyVersion != null;
    }

    public A withNewProxyVersion(String arg1){
            return (A)withProxyVersion(new String(arg1));
    }

    public A withNewProxyVersion(StringBuilder arg1){
            return (A)withProxyVersion(new String(arg1));
    }

    public A withNewProxyVersion(StringBuffer arg1){
            return (A)withProxyVersion(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ProxyMatchFluentImpl that = (ProxyMatchFluentImpl) o;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (proxyVersion != null ? !proxyVersion.equals(that.proxyVersion) :that.proxyVersion != null) return false;
            return true;
    }




}
