package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RegexMatchTypeBuilder extends RegexMatchTypeFluentImpl<RegexMatchTypeBuilder> implements VisitableBuilder<RegexMatchType,RegexMatchTypeBuilder>{

    RegexMatchTypeFluent<?> fluent;
    Boolean validationEnabled;

    public RegexMatchTypeBuilder(){
            this(true);
    }
    public RegexMatchTypeBuilder(Boolean validationEnabled){
            this(new RegexMatchType(), validationEnabled);
    }
    public RegexMatchTypeBuilder(RegexMatchTypeFluent<?> fluent){
            this(fluent, true);
    }
    public RegexMatchTypeBuilder(RegexMatchTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RegexMatchType(), validationEnabled);
    }
    public RegexMatchTypeBuilder(RegexMatchTypeFluent<?> fluent,RegexMatchType instance){
            this(fluent, instance, true);
    }
    public RegexMatchTypeBuilder(RegexMatchTypeFluent<?> fluent,RegexMatchType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRegex(instance.getRegex()); 
            this.validationEnabled = validationEnabled; 
    }
    public RegexMatchTypeBuilder(RegexMatchType instance){
            this(instance,true);
    }
    public RegexMatchTypeBuilder(RegexMatchType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRegex(instance.getRegex()); 
            this.validationEnabled = validationEnabled; 
    }

    public RegexMatchType build(){
            RegexMatchType buildable = new RegexMatchType(fluent.getRegex());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RegexMatchTypeBuilder that = (RegexMatchTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
