
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "gateway",
    "name",
    "portName",
    "portNumber",
    "vhost"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RouteConfigurationMatch implements Serializable
{

    /**
     * 
     */
    @JsonProperty("gateway")
    @JsonPropertyDescription("")
    private String gateway;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("portName")
    @JsonPropertyDescription("")
    private String portName;
    /**
     * 
     */
    @JsonProperty("portNumber")
    @JsonPropertyDescription("")
    private Integer portNumber;
    /**
     * 
     */
    @JsonProperty("vhost")
    @JsonPropertyDescription("")
    private VirtualHostMatch vhost;
    private final static long serialVersionUID = 4095170434944464057L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RouteConfigurationMatch() {
    }

    /**
     * 
     * @param vhost
     * @param name
     * @param portName
     * @param gateway
     * @param portNumber
     */
    public RouteConfigurationMatch(String gateway, String name, String portName, Integer portNumber, VirtualHostMatch vhost) {
        super();
        this.gateway = gateway;
        this.name = name;
        this.portName = portName;
        this.portNumber = portNumber;
        this.vhost = vhost;
    }

    /**
     * 
     */
    public String getGateway() {
        return gateway;
    }

    /**
     * 
     */
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public String getPortName() {
        return portName;
    }

    /**
     * 
     */
    public void setPortName(String portName) {
        this.portName = portName;
    }

    /**
     * 
     */
    public Integer getPortNumber() {
        return portNumber;
    }

    /**
     * 
     */
    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    /**
     * 
     */
    public VirtualHostMatch getVhost() {
        return vhost;
    }

    /**
     * 
     */
    public void setVhost(VirtualHostMatch vhost) {
        this.vhost = vhost;
    }

}
