package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteConfigurationMatchBuilder extends RouteConfigurationMatchFluentImpl<RouteConfigurationMatchBuilder> implements VisitableBuilder<RouteConfigurationMatch,RouteConfigurationMatchBuilder>{

    RouteConfigurationMatchFluent<?> fluent;
    Boolean validationEnabled;

    public RouteConfigurationMatchBuilder(){
            this(true);
    }
    public RouteConfigurationMatchBuilder(Boolean validationEnabled){
            this(new RouteConfigurationMatch(), validationEnabled);
    }
    public RouteConfigurationMatchBuilder(RouteConfigurationMatchFluent<?> fluent){
            this(fluent, true);
    }
    public RouteConfigurationMatchBuilder(RouteConfigurationMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteConfigurationMatch(), validationEnabled);
    }
    public RouteConfigurationMatchBuilder(RouteConfigurationMatchFluent<?> fluent,RouteConfigurationMatch instance){
            this(fluent, instance, true);
    }
    public RouteConfigurationMatchBuilder(RouteConfigurationMatchFluent<?> fluent,RouteConfigurationMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGateway(instance.getGateway()); 
            fluent.withName(instance.getName()); 
            fluent.withPortName(instance.getPortName()); 
            fluent.withPortNumber(instance.getPortNumber()); 
            fluent.withVhost(instance.getVhost()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteConfigurationMatchBuilder(RouteConfigurationMatch instance){
            this(instance,true);
    }
    public RouteConfigurationMatchBuilder(RouteConfigurationMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGateway(instance.getGateway()); 
            this.withName(instance.getName()); 
            this.withPortName(instance.getPortName()); 
            this.withPortNumber(instance.getPortNumber()); 
            this.withVhost(instance.getVhost()); 
            this.validationEnabled = validationEnabled; 
    }

    public RouteConfigurationMatch build(){
            RouteConfigurationMatch buildable = new RouteConfigurationMatch(fluent.getGateway(),fluent.getName(),fluent.getPortName(),fluent.getPortNumber(),fluent.getVhost());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteConfigurationMatchBuilder that = (RouteConfigurationMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
