package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface RouteConfigurationMatchFluent<A extends RouteConfigurationMatchFluent<A>> extends Fluent<A>{


    public String getGateway();
    public A withGateway(String gateway);
    public Boolean hasGateway();
    public A withNewGateway(String arg1);
    public A withNewGateway(StringBuilder arg1);
    public A withNewGateway(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getPortName();
    public A withPortName(String portName);
    public Boolean hasPortName();
    public A withNewPortName(String arg1);
    public A withNewPortName(StringBuilder arg1);
    public A withNewPortName(StringBuffer arg1);
    public Integer getPortNumber();
    public A withPortNumber(Integer portNumber);
    public Boolean hasPortNumber();
    
/**
 * This method has been deprecated, please use method buildVhost instead.
 * @return The buildable object.
 */
@Deprecated public VirtualHostMatch getVhost();
    public VirtualHostMatch buildVhost();
    public A withVhost(VirtualHostMatch vhost);
    public Boolean hasVhost();
    public RouteConfigurationMatchFluent.VhostNested<A> withNewVhost();
    public RouteConfigurationMatchFluent.VhostNested<A> withNewVhostLike(VirtualHostMatch item);
    public RouteConfigurationMatchFluent.VhostNested<A> editVhost();
    public RouteConfigurationMatchFluent.VhostNested<A> editOrNewVhost();
    public RouteConfigurationMatchFluent.VhostNested<A> editOrNewVhostLike(VirtualHostMatch item);

    public interface VhostNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VirtualHostMatchFluent<RouteConfigurationMatchFluent.VhostNested<N>>{

        
    public N and();    public N endVhost();
}


}
