package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class RouteConfigurationMatchFluentImpl<A extends RouteConfigurationMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteConfigurationMatchFluent<A>{

    private String gateway;
    private String name;
    private String portName;
    private Integer portNumber;
    private VirtualHostMatchBuilder vhost;

    public RouteConfigurationMatchFluentImpl(){
    }
    public RouteConfigurationMatchFluentImpl(RouteConfigurationMatch instance){
            this.withGateway(instance.getGateway()); 
            this.withName(instance.getName()); 
            this.withPortName(instance.getPortName()); 
            this.withPortNumber(instance.getPortNumber()); 
            this.withVhost(instance.getVhost()); 
    }

    public String getGateway(){
            return this.gateway;
    }

    public A withGateway(String gateway){
            this.gateway=gateway; return (A) this;
    }

    public Boolean hasGateway(){
            return this.gateway != null;
    }

    public A withNewGateway(String arg1){
            return (A)withGateway(new String(arg1));
    }

    public A withNewGateway(StringBuilder arg1){
            return (A)withGateway(new String(arg1));
    }

    public A withNewGateway(StringBuffer arg1){
            return (A)withGateway(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getPortName(){
            return this.portName;
    }

    public A withPortName(String portName){
            this.portName=portName; return (A) this;
    }

    public Boolean hasPortName(){
            return this.portName != null;
    }

    public A withNewPortName(String arg1){
            return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(StringBuilder arg1){
            return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(StringBuffer arg1){
            return (A)withPortName(new String(arg1));
    }

    public Integer getPortNumber(){
            return this.portNumber;
    }

    public A withPortNumber(Integer portNumber){
            this.portNumber=portNumber; return (A) this;
    }

    public Boolean hasPortNumber(){
            return this.portNumber != null;
    }

    
/**
 * This method has been deprecated, please use method buildVhost instead.
 * @return The buildable object.
 */
@Deprecated public VirtualHostMatch getVhost(){
            return this.vhost!=null?this.vhost.build():null;
    }

    public VirtualHostMatch buildVhost(){
            return this.vhost!=null?this.vhost.build():null;
    }

    public A withVhost(VirtualHostMatch vhost){
            _visitables.get("vhost").remove(this.vhost);
            if (vhost!=null){ this.vhost= new VirtualHostMatchBuilder(vhost); _visitables.get("vhost").add(this.vhost);} return (A) this;
    }

    public Boolean hasVhost(){
            return this.vhost != null;
    }

    public RouteConfigurationMatchFluent.VhostNested<A> withNewVhost(){
            return new VhostNestedImpl();
    }

    public RouteConfigurationMatchFluent.VhostNested<A> withNewVhostLike(VirtualHostMatch item){
            return new VhostNestedImpl(item);
    }

    public RouteConfigurationMatchFluent.VhostNested<A> editVhost(){
            return withNewVhostLike(getVhost());
    }

    public RouteConfigurationMatchFluent.VhostNested<A> editOrNewVhost(){
            return withNewVhostLike(getVhost() != null ? getVhost(): new VirtualHostMatchBuilder().build());
    }

    public RouteConfigurationMatchFluent.VhostNested<A> editOrNewVhostLike(VirtualHostMatch item){
            return withNewVhostLike(getVhost() != null ? getVhost(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RouteConfigurationMatchFluentImpl that = (RouteConfigurationMatchFluentImpl) o;
            if (gateway != null ? !gateway.equals(that.gateway) :that.gateway != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (portName != null ? !portName.equals(that.portName) :that.portName != null) return false;
            if (portNumber != null ? !portNumber.equals(that.portNumber) :that.portNumber != null) return false;
            if (vhost != null ? !vhost.equals(that.vhost) :that.vhost != null) return false;
            return true;
    }


    public class VhostNestedImpl<N> extends VirtualHostMatchFluentImpl<RouteConfigurationMatchFluent.VhostNested<N>> implements RouteConfigurationMatchFluent.VhostNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final VirtualHostMatchBuilder builder;
    
            VhostNestedImpl(VirtualHostMatch item){
                    this.builder = new VirtualHostMatchBuilder(this, item);
            }
            VhostNestedImpl(){
                    this.builder = new VirtualHostMatchBuilder(this);
            }
    
    public N and(){
            return (N) RouteConfigurationMatchFluentImpl.this.withVhost(builder.build());
    }
    public N endVhost(){
            return and();
    }

}


}
